% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\docType{methods}
\name{involvedVariables}
\alias{involvedVariables}
\alias{involvedVariables,symbolicQspray-method}
\title{Variables involved in a 'symbolicQspray' polynomial}
\usage{
\S4method{involvedVariables}{symbolicQspray}(x)
}
\arguments{
\item{x}{a \code{symbolicQspray} object}
}
\value{
A vector of integers. Each integer represents the index of a
  variable involved in \code{x}.
}
\description{
Variables involved in a \code{symbolicQspray} object.
}
\examples{
a1 <- qlone(1); a2 <- qlone(2)
X <- Qlone(1); Z <- Qlone(3)
Qspray <- (a1/a2)*X^2 + (a1/(a1+a2))*X*Z + a2^2/a1
involvedVariables(Qspray) # should be c(1L, 3L)
}
\seealso{
\code{\link{numberOfVariables}}.
}
