% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetting.R
\name{subsetting}
\alias{subsetting}
\alias{[.das_dfr}
\alias{$<-.das_dfr}
\alias{[<-.das_dfr}
\alias{[[<-.das_dfr}
\alias{[.das_df}
\alias{$<-.das_df}
\alias{[<-.das_df}
\alias{[[<-.das_df}
\title{Subsetting objects created using swfscDAS}
\usage{
\method{[}{das_dfr}(x, i, j, ..., drop = TRUE)

\method{$}{das_dfr}(x, name) <- value

\method{[}{das_dfr}(x, i, j, ...) <- value

\method{[[}{das_dfr}(x, i) <- value

\method{[}{das_df}(x, i, j, ..., drop = TRUE)

\method{$}{das_df}(x, name) <- value

\method{[}{das_df}(x, i, j, ...) <- value

\method{[[}{das_df}(x, i) <- value
}
\arguments{
\item{x}{object of class \code{das_dfr} or \code{das_df}}

\item{i, j, ...}{elements to extract or replace, see \code{\link[base]{[.data.frame}}}

\item{drop}{logical, see \code{\link[base]{[.data.frame}}}

\item{name}{A literal character string or ..., see \code{\link[base]{[.data.frame}}}

\item{value}{A suitable replacement value, see \code{\link[base]{[.data.frame}}}
}
\description{
Subsetting \code{das_dfr} or \code{das_df} objects
}
\details{
When subsetting a \code{das_dfr} or \code{das_df} object, henceforth a \code{das_} object,
using any of the functions described in \code{\link[base]{[.data.frame}},
then then the \code{das_} class is simply dropped and the object is of class \code{data.frame}.
This is because of the strict format requirements of \code{das_} objects;
it is likely that a subsetted \code{das_} object will not have
the format required by subsequent swfscDAS functions,
and thus it is safest to drop the \code{das_} class.
If a data frame is passed to downstream \code{swfscDAS} functions that require a \code{das_} object,
then they will attempt to coerce the object to the necessary \code{das_} class
See \code{\link{as_das_dfr}} and \code{\link{as_das_df}} for more details.
}
\examples{
y <- system.file("das_sample.das", package = "swfscDAS")
y.read <- das_read(y)

# All return a data frame:
class(y.read[1:10, ])
class(y.read[, 1:10])

y.df <- y.read
y.df[, 1] <- "a"
class(y.df)

y.df <- y.read
y.df$Event <- "a"
class(y.df)

y.df <- y.read
y.df[["Event"]] <- "a"
class(y.df)
}
