% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetting.R
\name{subsetting}
\alias{subsetting}
\alias{[.airdas_dfr}
\alias{$<-.airdas_dfr}
\alias{[<-.airdas_dfr}
\alias{[[<-.airdas_dfr}
\alias{[.airdas_df}
\alias{$<-.airdas_df}
\alias{[<-.airdas_df}
\alias{[[<-.airdas_df}
\title{Subsetting objects created using swfscAirDAS}
\usage{
\method{[}{airdas_dfr}(x, i, j, ..., drop = TRUE)

\method{$}{airdas_dfr}(x, name) <- value

\method{[}{airdas_dfr}(x, i, j, ...) <- value

\method{[[}{airdas_dfr}(x, i) <- value

\method{[}{airdas_df}(x, i, j, ..., drop = TRUE)

\method{$}{airdas_df}(x, name) <- value

\method{[}{airdas_df}(x, i, j, ...) <- value

\method{[[}{airdas_df}(x, i) <- value
}
\arguments{
\item{x}{object of class \code{airdas_dfr} or \code{airdas_df}}

\item{i, j, ...}{elements to extract or replace, see \link{[.data.frame}}

\item{drop}{logical, see \link{[.data.frame}}

\item{name}{A literal character string or ..., see \link{[.data.frame}}

\item{value}{A suitable replacement value, see \link{[.data.frame}}
}
\description{
Subsetting \code{airdas_dfr} or \code{airdas_df} objects
}
\details{
When subsetting a \code{airdas_dfr} or \code{airdas_df} object, henceforth a \code{airdas_} object,
using any of the functions described in \link{[.data.frame},
then then the \code{airdas_} class is simply dropped and the object is of class \code{data.frame}.
This is because of the strict format requirements of \code{airdas_} objects;
it is likely that a subsetted \code{airdas_} object will not have
the format required by subsequent swfscAirDAS functions,
and thus it is safest to drop the \code{airdas_} class.
If a data frame is passed to downstream \code{swfscAirDAS} functions that require a \code{airdas_} object,
then they will attempt to coerce the object to the necessary \code{airdas_} class
See \code{\link{as_airdas_dfr}} and \code{\link{as_airdas_df}} for more details.
}
\examples{
y <- system.file("airdas_sample.das", package = "swfscAirDAS")
y.read <- airdas_read(y)

# All return a data frame:
class(y.read[1:10, ])
class(y.read[, 1:10])

y.df <- y.read
y.df[, 1] <- "a"
class(y.df)

y.df <- y.read
y.df$Event <- "a"
class(y.df)

y.df <- y.read
y.df[["Event"]] <- "a"
class(y.df)
}
