% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Section2.R
\name{Section2}
\alias{Section2}
\alias{swe_calc_ut}
\alias{swe_calc}
\title{Section 2: Computing positions}
\usage{
swe_calc_ut(jd_ut, ipl, iflag)

swe_calc(jd_et, ipl, iflag)
}
\arguments{
\item{jd_ut}{UT Julian day number as double (day)}

\item{ipl}{Body/planet as integer (SE$SUN=0, SE$Moon=1,  ... SE$PLUTO=9)}

\item{iflag}{Computation flag as integer, many options possible (section 2.3)}

\item{jd_et}{ET Julian day number as double (day)}
}
\value{
\code{swe_calc_ut} returns a list with named entries: \code{return} status flag as integer,
       \code{xx} information on planet position, and \code{serr} error message as string.

\code{swe_calc} returns a list with named entries: \code{return} status flag as integer,
        \code{xx} updated star name as string and \code{serr} error message as string.
}
\description{
Computing positions of planets, asteroids, lunar nodes and apogees using Swiss Ephemeris.
}
\details{
\describe{
  \item{swe_calc_ut()}{It compute positions using UT.} 
  \item{swe_calc()}{It compute positions using ET.}
}
}
\examples{
data(SE)
swe_calc_ut(2458346.82639, SE$MOON, SE$FLG_MOSEPH)
swe_calc(2458346.82639, SE$MOON, SE$FLG_MOSEPH)
}
\seealso{
\url{http://www.astro.com/swisseph/swephprg.htm#_Toc505244837}
}
