% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_shape.R
\name{group_shape}
\alias{group_shape}
\title{Group Shape Based on a OOBB}
\usage{
group_shape(x, y, hs, geo = FALSE)
}
\arguments{
\item{x}{A vector of x (or longitude) coordinates.}

\item{y}{A vector of y (or latitude) coordinates.}

\item{hs}{A vector of headings of the objects (in degrees).}

\item{geo}{A logical value indicating whether the locations are defined by
geographic coordinates (pairs of longitude/latitude values). Default: FALSE.}
}
\value{
A list with the estimate of how oblong the group is, and the details
 of the bounding box, i.e. its coordinates, height, width, and orientation of
 its longest side in degrees.
}
\description{
Calculates how oblong the shape of a group is, relative to its
 average moving direction, along with the properties of the minimum object
 oriented bounding box (OOBB) around all objects.
}
\examples{

x <- rnorm(25)
y <- rnorm(25, sd = 3)
h <- runif(25, 0, 2 * pi)
group_shape(x, y, h, geo = FALSE)

}
\author{
Marina Papadopoulou, \email{m.papadopoulou.rug@gmail.com}
}
