% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{fast_lra}
\alias{fast_lra}
\title{Logratio Analysis}
\usage{
fast_lra(dat, base = exp(1))
}
\arguments{
\item{dat}{Input data: can be a table or a data frame (but the data frame must have only two columns).}

\item{base}{Numeric specification of the base with respect to which logarithms are computed.}
}
\value{
A list with components:
\item{\code{val} }{The eigenvalues (i.e. squared singular values), indicating how much each latent axis explains.}
\item{\code{pos1} }{The coordinates of the first set of levels (\emph{viz.} the row levels of a frequency table).}
\item{\code{pos2} }{The coordinates of the second set of levels (\emph{viz.} the column levels of a frequency table).}
}
\description{
A fast procedure for computing logratio analysis.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
lra.SndT_Fra <- fast_lra(SndT_Fra)
lra.SndT_Fra
}
\references{
Greenacre, M. (2019) \emph{Compositional data analysis in practice}. Boca Raton: Chapman and Hall/CRC.

Van den Boogaart, K. G. and R. Tolosana-Delgado (2013) \emph{Analyzing compositional data with R}. Berlin: Springer.
}
