% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fast_mca}
\alias{fast_mca}
\title{Multiple Correspondence Analysis}
\usage{
fast_mca(dat, nfac = FALSE)
}
\arguments{
\item{dat}{Input data: has to be a data frame (with any number of columns).}

\item{nfac}{Logical indicating whether the number of factors (i.e. the number of columns in \code{dat}) is a divisor for
the eigenvalues (principal inertias) and the coordinates.}
}
\value{
A list with components:
\item{\code{val} }{The eigenvalues or principal inertias, indicating how much each latent axis explains.}
\item{\code{pos} }{The coordinates of all levels.}
}
\description{
A fast procedure for computing multiple correspondence analysis.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\\t", quote = "\\"", encoding = "UTF-8")
mca.SndT_Fra <- fast_mca(SndT_Fra)
mca.SndT_Fra
}
\references{
Greenacre, M. (2007) \emph{Correspondence analysis in practice, Second edition}. Boca Raton: Chapman and Hall/CRC.
}

