% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVG.R
\name{svgstring}
\alias{svgstring}
\title{Access current SVG as a string.}
\usage{
svgstring(width = 10, height = 8, bg = "white", pointsize = 12,
  standalone = TRUE, system_fonts = list(), user_fonts = list())
}
\arguments{
\item{width}{Height and width in inches.}

\item{height}{Height and width in inches.}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{pointsize}{Default point size.}

\item{standalone}{Produce a standalone svg file? If \code{FALSE}, omits
xml header and default namespace.}

\item{system_fonts}{Named list of font names to be aliased with
fonts installed on your system. If unspecified, the R default
families \code{sans}, \code{serif}, \code{mono} and \code{symbol}
are aliased to the family returned by
\code{\link[gdtools]{match_family}()}.}

\item{user_fonts}{Named list of fonts to be aliased with font files
provided by the user rather than fonts properly installed on the
system. The aliases can be fonts from the fontquiver package,
strings containing a path to a font file, or a list containing
\code{name} and \code{file} elements with \code{name} indicating
the font alias in the SVG output and \code{file} the path to a
font file.}

\item{...}{Arguments passed on to \code{\link{svglite}}.}
}
\value{
A function with no arguments: call the function to get the
  current value of the string.
}
\description{
This is a variation on \code{\link{svglite}} that makes it easy to access
the current value as a string.
}
\details{
See \code{\link{svglite}()} documentation for information about
specifying fonts.
}
\examples{
s <- svgstring(); s()

plot.new(); s();
text(0.5, 0.5, "Hi!"); s()
dev.off()

s <- svgstring()
plot(rnorm(5), rnorm(5))
s()
dev.off()
}
