% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system_file.R
\name{system_file}
\alias{system_file}
\alias{system_dir}
\alias{systemFile}
\alias{systemDir}
\title{Get a system file or directory}
\usage{
system_file(..., exec = FALSE, package = NULL, lib.loc = NULL)

system_dir(..., exec = FALSE, package = NULL, lib.loc = NULL)

systemFile(..., exec = FALSE, package = NULL, lib.loc = NULL)

systemDir(..., exec = FALSE, package = NULL, lib.loc = NULL)
}
\arguments{
\item{...}{One or several executables if \code{exec = TRUE}, or subpath to a file
or dir in a package directory if \code{package != NULL}, or a list of paths and
subpaths for testing the existence of a file on disk, or a list of directory
components to retrieve in 'temp', 'sysTemp', 'user', 'home', 'bin', 'doc',
'etc' and/or 'share' to retrieve special system directories.}

\item{exec}{If \code{TRUE} (default) search for executables on the search path.
It superseedes all other arguments.}

\item{package}{The name of one package to look for files or subdirs in its
main directory (use \code{exec = FALSE} to search inside package dirs).}

\item{lib.loc}{A character vector with path names of \R libraries or \code{NULL}
(search all currently known libraries in this case).}
}
\value{
A string with the path to the directories or files, or \code{""} if they
are not found, or of the wrong type (a dir for \code{system_file()} or or a file
for \code{system_dir()}).
}
\description{
Get system files or directories, in R subdirectories, in package
subdirectories, or elsewhere on the disk (including executables that are
accessible on the search path).
}
\note{
These function aggregate the features of several \R functions in
package base: \code{\link[=system.file]{system.file()}}, \code{\link[=R.home]{R.home()}}, \code{\link[=tempdir]{tempdir()}}, \code{\link[=Sys.which]{Sys.which()}}, and
aims to provide a unified and convenient single interface to all of them. We
make sure also to check that returned components are respectively directories
and files for \code{system_dir()} and \code{system_file()}.
}
\examples{
system_file("INDEX", package = "base")
system_file("help", "AnIndex", package = "splines")
system_file(package = "base")  # This is a dir, not a file!
system_file("zip", exec = TRUE)
system_file("ftp", "ping", "zip", "nonexistingexe", exec = TRUE)
system_dir("temp")             # The R temporary directory
system_dir("sysTemp")          # The system temporary directory
system_dir("user")             # The user directory
system_dir("home", "bin", "doc", "etc", "share")  # Various R dirs
system_dir("zip", exec = TRUE) # Look for the dir of an executable
system_dir("ftp", "ping", "zip", "nonexistingexe", exec = TRUE)
system_dir(package = "base")   # The root of the 'base' package
system_dir(package = "stats")  # The root of package 'stats'
system_dir("INDEX", package = "stats") # This is a file, not a dir!
system_dir("help", package = "splines")
}
\seealso{
\code{\link[=file_edit]{file_edit()}}, \code{\link[=file.path]{file.path()}}, \code{\link[=file.exists]{file.exists()}}
}
\concept{
system files and directories
}
\keyword{utilities}
