% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameters.R
\name{eta_star}
\alias{eta_star}
\title{Calculates parameter \eqn{\eta^*} of \eqn{q^*(\sigma^2_{\gamma})} to
optimize the evidence based lower bound (ELBO) in
\code{survregVB.frailty.fit}.}
\usage{
eta_star(eta_0, tau, sigma)
}
\arguments{
\item{eta_0}{The scale hyperparameter \eqn{\eta_0} of the prior distribution
of the frailty variance, \eqn{\sigma_\gamma^2}.}

\item{tau}{Parameter \eqn{\tau^*} of \eqn{q^*(\gamma_i)}, a vector of
means.}

\item{sigma}{Parameter \eqn{\sigma^{2*}_i} of \eqn{q^*(\gamma_i)}, a
vector of variance.}
}
\value{
Parameter \eqn{\eta^*} of \eqn{q^*(\sigma^2_{\gamma})}.
}
\description{
Calculates parameter \eqn{\eta^*} of \eqn{q^*(\sigma^2_{\gamma})} to
optimize the evidence based lower bound (ELBO) in
\code{survregVB.frailty.fit}.
}
\seealso{
\code{\link{survregVB.frailty.fit}}
}
