% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_site_data.R
\name{simulate_site_data}
\alias{simulate_site_data}
\title{Simulate site data}
\usage{
simulate_site_data(
  n_sites,
  n_features,
  proportion_of_sites_missing_data,
  n_env_vars = 3,
  survey_cost_intensity = 10,
  survey_cost_radius = 0.5,
  management_cost_intensity = 100,
  management_cost_radius = 0.5,
  max_number_surveys_per_site = 5,
  output_probabilities = TRUE
)
}
\arguments{
\item{n_sites}{\code{integer} number of sites.}

\item{n_features}{\code{integer} number of features.}

\item{proportion_of_sites_missing_data}{\code{numeric} proportion of sites
that do not have existing presence/absence data. Values must be between
zero and one.}

\item{n_env_vars}{\code{integer} number of environmental variables for
simulating feature distributions. Defaults to 3.}

\item{survey_cost_intensity}{\code{numeric} intensity of the costs of
surveying sites. Larger values correspond to larger costs on average.
Defaults to 2.}

\item{survey_cost_radius}{\code{numeric} value corresponding to
the spatial homogeneity of the survey costs. Defaults to 0.1.}

\item{management_cost_intensity}{\code{numeric} intensity of the costs of
average cost of managing sites for conservation. Defaults to 100.}

\item{management_cost_radius}{\code{numeric} value corresponding to
the spatial homogeneity of the survey costs. Defaults to 0.1.}

\item{max_number_surveys_per_site}{\code{integer} maximum number of
surveys per site in the simulated data. Defaults to 5.}

\item{output_probabilities}{\code{logical} value indicating if
probability values of occupancy should be output or not. Defaults
to \code{TRUE}.}
}
\value{
\code{\link[sf:sf]{sf::sf()}} object with site data.
The \code{"management_cost"} column contains the site protection costs,
and the \code{"survey_cost"} column contains the costs for surveying
each site.
Additionally, columns that start with
(i) \code{"f"} (e.g. \code{"f1"}) contain the proportion of
times that each feature was detected in each site,
(ii) \code{"n"} (e.g. \code{"n1"}) contain the number of
of surveys for each feature within each site,
(iii) \code{"p"} (e.g. \code{"p1"}) contain prior
probability data,  and
(iv) \code{"e"} (e.g. \code{"e1"}) contain environmental
data. Note that columns that contain the same integer value (excepting
environmental data columns) correspond to the same feature
(e.g. \code{"d1"}, \code{"n1"}, \code{"p1"} contain data that correspond
to the same feature).
}
\description{
Simulate site data for developing simulated survey schemes.
}
\details{
The data are simulated using random fields
(\code{\link[RandomFields:RFsimulate]{RandomFields::RFsimulate()}}) to provide spatially auto-correlated
simulations.
}
\examples{
# set seed for reproducibility
set.seed(123)
RandomFields::RFoptions(seed = 123)

# simulate data
d <- simulate_site_data(n_sites = 10, n_features = 4, prop = 0.5)

# print data
print(d, width = Inf)

# plot cost data
plot(d[, c("survey_cost", "management_cost")], axes = TRUE, pch = 16,
     cex = 2)

# plot environmental data
plot(d[, c("e1", "e2", "e3")], axes = TRUE, pch = 16, cex = 2)

# plot feature detection data
plot(d[, c("f1", "f2", "f3", "f4")], axes = TRUE, pch = 16, cex = 2)

# plot feature survey effort
plot(d[, c("n1", "n2", "n3", "n4")], axes = TRUE, pch = 16, cex = 2)

# plot feature prior probability data
plot(d[, c("p1", "p2", "p3", "p4")], axes = TRUE, pch = 16, cex = 2)

}
\seealso{
\code{\link[=simulate_feature_data]{simulate_feature_data()}}
}
