% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleandata.R
\name{remove_all_dont_know}
\alias{remove_all_dont_know}
\title{Removes "Do not know" and other similar words from factor levels in data frame.}
\usage{
remove_all_dont_know(x, dk = NULL, message = TRUE)
}
\arguments{
\item{x}{List or data frame}

\item{dk}{Character vector, containing search terms, e.g. \code{c("Do not know", "DK")}.  These terms will be replaced by \code{NA}. If \code{NULL}, defaults to \code{c("I don't know", "Don't Know", "Don't know", "Dont know" , "DK")}}

\item{message}{If TRUE, displays message with the number of instances that were removed.}
}
\value{
A data frame
}
\description{
Removes "Do not know" and other similar words from factor levels in data frame
}
\seealso{
\code{\link[=hasDK]{hasDK()}} and \code{\link[=removeDK]{removeDK()}}

Other Functions to clean data: \code{\link{encToInt}},
  \code{\link{fix_common_encoding_problems}},
  \code{\link{fix_levels_01_spss}},
  \code{\link{has_dont_know}}, \code{\link{intToEnc}},
  \code{\link{leveltest}}, \code{\link{remove_dont_know}}
}
\concept{Functions to clean data}
\keyword{"clean}
\keyword{data"}
