% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{DerivCumulHazard}
\alias{DerivCumulHazard}
\title{Cumulative hazard (integral of hazard) and its first and second derivatives wrt regression parameters beta}
\usage{
DerivCumulHazard(
  X_GL,
  weights,
  tm,
  n_legendre,
  n,
  p,
  beta,
  expected,
  type,
  is_pwcst,
  pwcst_weights
)
}
\arguments{
\item{X_GL}{list of matrices (\code{length(X.GL)=n.legendre}) for Gauss-Legendre quadrature}

\item{weights}{vector of weights for Gauss-Legendre integration on [-1;1]}

\item{tm}{vector of midpoints times for Gauss-Legendre integration; tm = 0.5*(t1 - t0)}

\item{n_legendre}{number of nodes for Gauss-Legendre quadrature}

\item{n}{number of individuals in the dataset}

\item{p}{number of regression parameters}

\item{beta}{vector of estimated regression parameters}

\item{expected}{vector of expected hazard rates}

\item{type}{"net", "overall" or "mult"}

\item{is_pwcst}{True if there is a piecewise constant baseline specified. False otherwise}

\item{pwcst_weights}{if is.pwcst is TRUE, matrix of weights giving the time contribution of each individual on each sub-interval. Otherwise NULL}
}
\value{
List of objects with the following items:
\item{integral}{cumulative hazard (integral of hazard)}
\item{f.first}{first derivative of cumulative hazard wrt beta}
\item{f.second}{second derivative of cumulative hazard wrt beta}
}
\description{
Cumulative hazard (integral of hazard) and its first and second derivatives wrt regression parameters beta
}
