% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_hr_pi.R
\name{calc_hr_pi}
\alias{calc_hr_pi}
\title{Generate hazard ratio with prediction intervals from parametric bootstrap simulation}
\usage{
calc_hr_pi(
  sim,
  trt,
  group = NULL,
  pi.range = 0.95,
  calc.obs = TRUE,
  trt.assign = c("default", "reverse")
)
}
\arguments{
\item{sim}{A \code{survparamsim} class object generated by \code{\link{surv_param_sim}} function.}

\item{trt}{A string to specify which column define treatment status to calculate HR.
The specified column should have only two levels.}

\item{group}{Optional string(s) to specify grouping variable(s).
You will have faceted histograms for these variables in \code{\link{plot_hr_pi}} function.}

\item{pi.range}{Prediction interval for simulated HR.}

\item{calc.obs}{A logical to specify whether to calculate HR for the observed data.
Need be set as FALSE if survival information in the \code{newdata} is dummy.}

\item{trt.assign}{Specify which of the categories of \code{trt} need to be considered as control group.}
}
\description{
Generate hazard ratio with prediction intervals from parametric bootstrap simulation
}
