% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plottingFunctions.r
\name{superbPlot.bar}
\alias{superbPlot.bar}
\alias{superbPlot.line}
\alias{superbPlot.point}
\alias{superbPlot.pointjitter}
\alias{superbPlot.pointjitterviolin}
\alias{superbPlot.pointindividualline}
\title{superbPlot templates}
\usage{
superbPlot.bar(
  summarydata,
  xvar,
  groupingfac,
  addfactors,
  Debug = FALSE,
  rawdata = NULL,
  barParams = list(),
  errorbarParams = list(),
  facetParams = list()
)
}
\arguments{
\item{summarydata}{a data.frame with columns "center", "lowerwidth" and "upperwidth" for each level of the factors;}

\item{xvar}{a string with the name of the column where the factor going on the horizontal axis is given;}

\item{groupingfac}{a string with the name of the column for which the data will be grouped on the plot;}

\item{addfactors}{a string with up to two additional factors to make the rows and columns panels, in the form "fact1 ~ fact2";}

\item{Debug}{a boolean to display or not debugging information}

\item{rawdata}{always contains "DV" for each participants and each level of the factors}

\item{barParams}{(optional) list of graphic directives that are sent to the geom_bar layer}

\item{errorbarParams}{(optional) list of graphic directives that are sent to the geom_errorbar layer}

\item{facetParams}{(optional) list of graphic directives that are sent to the facet_grid layer}
}
\value{
a ggplot object
}
\description{
superbPlot comes with a few built-in templates for
for making the final plots. All produces ggplot objects that
can be further customized. Additionally, it is possible to add
custom-make templates (see vignette 6). The functions, to be 
"superbPlot-compatible", must have these parameters:

If you have useful styles, do contribute github.com/dcousin3/superb
by opening an issue.
Finally, any number of optional list of parameters with default value set to list()
can be provided depending on the template style. These includes errorbarParams,
pointParams, barParams, etc.
}
