% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summclust.R
\name{summclust}
\alias{summclust}
\title{Compute Influence and Leverage Metrics}
\usage{
summclust(obj, ...)
}
\arguments{
\item{obj}{An object of class \code{lm} or \code{fixest}}

\item{...}{Other arguments}
}
\value{
An object of type \code{summclust}, including
a CRV3 variance-covariance estimate as described in
MacKinnon, Nielsen & Webb (2022)
}
\description{
Compute influence and leverage metrics for clustered inference
based on the Cluster Jackknife described in MacKinnon, Nielsen & Webb
(2022).
}
\examples{

library(summclust)
data(mtcars)
mtcars

fit <- lm(mpg ~ cyl + disp + hp, data = mtcars)
summ <- summclust(fit, params = ~cyl + disp, cluster = ~carb)
summary(summ)
tidy(summ)
plot(summ)
}
\references{
MacKinnon, James G., Morten Ørregaard Nielsen, and Matthew D. Webb.
"Leverage, influence, and the jackknife in clustered regression models:
Reliable inference using summclust."
arXiv preprint arXiv:2205.03288 (2022).
}
\seealso{
\link[summclust]{summclust.lm},
\link[summclust]{summclust.fixest}
}
