% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_table.R
\name{clean_table}
\alias{clean_table}
\title{Standardize missing value display across all gtsummary table types}
\usage{
clean_table(tbl)
}
\arguments{
\item{tbl}{A gtsummary table object (e.g., from \code{tbl_summary()}, \code{tbl_svysummary()},
\code{tbl_regression()}, or \code{tbl_strata()})}
}
\value{
A gtsummary table object with standardized missing value display
}
\description{
Improves table readability by replacing various missing value
representations with a consistent "--" symbol. This makes it easier to
distinguish between actual data and missing/undefined values in summary
tables, creating a cleaner and more professional appearance.

Works seamlessly with all gtsummary table types, including stacked tables
(\code{tbl_strata}) and survey-weighted summaries (\code{tbl_svysummary}).
Automatically handles tables with or without the standard \code{var_type} column.
}
\details{
The function uses \code{gtsummary::modify_table_body()} to transform
character columns and replace common missing value patterns with "--":
\itemize{
\item \code{"0 (NA\%)"} - No events occurred and percentages cannot be calculated
\item \code{"NA (NA)"} - Completely missing data for both count and percentage
\item \code{"0 (0\%)"} - Zero counts with zero percentage
\item \code{"0\% (0.000)"} - Zero percentage with decimal precision
\item \code{"NA (NA, NA)"} - Missing data with confidence intervals
\item \code{"NA, NA"} - Missing paired values (e.g., median and IQR)
}

This standardization makes tables more scannable and reduces visual clutter
from various "empty" data representations.

Note: The function checks for the presence of \code{var_type} column before applying
\code{modify_missing_symbol()}. This allows it to work seamlessly with \code{tbl_strata}
objects which use \code{var_type_1}, \code{var_type_2}, etc. instead of \code{var_type}.
}
\examples{
\donttest{
# Basic usage - clean missing values in summary table
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  clean_table()

# Often used as part of a styling pipeline
# Create a test dictionary for add_auto_labels():
dictionary <- tibble::tribble(
  ~Variable, ~Description,
  'age', 'Age at enrollment',
  'stage', 'T Stage',
  'grade', 'Grade',
  'response', 'Tumor Response'
)
gtsummary::trial |>
  gtsummary::tbl_summary(by = trt) |>
  add_auto_labels() |>
  extras() |>
  clean_table()

# Works with regression tables too
lm(age ~ trt + grade, data = gtsummary::trial) |>
  gtsummary::tbl_regression() |>
  clean_table()
}

}
\seealso{
\itemize{
\item \code{gtsummary::modify_table_body()} for general table body modifications
\item \code{extras()} which includes \code{clean_table()} in its styling pipeline
}
}
