% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macro.R
\name{DSC_p3c}
\alias{DSC_p3c}
\title{P3C algorithm for use with DSC_ThreeStage}
\usage{
DSC_p3c(poissonThreshold = 10, chiSquareAlpha = 0.001)
}
\arguments{
\item{poissonThreshold}{threshold value to determine wheter two bins will be
 merged. Note that the value provided will be used as a negative power of 10.
 E.g. if a value of 20 is provided here, then the algorithm will use a
 threshold of 1.0*10^-20.
dsc <- DSC_ThreeStage(macro=DSC_p3c(),micro=DSC_subspaceCluStream())
dsd <- DSD_RandomRBFSubspaceGeneratorEvents()
update(dsc,dsd,1000)}

\item{chiSquareAlpha}{threshold value for the chi-square distribution that is
used to determine whether an area is dense.}
}
\description{
An implementation of the P3C algorithm 
that can be used with \link{DSC_ThreeStage}.
For more details on this
algorithm, consult \link[subspace]{P3C}
}

