% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subprocess.R
\docType{data}
\name{terminating}
\alias{TIMEOUT_IMMEDIATE}
\alias{TIMEOUT_INFINITE}
\alias{process_poll}
\alias{process_return_code}
\alias{process_wait}
\alias{terminating}
\title{Terminating a Child Process.}
\format{An object of class \code{integer} of length 1.}
\usage{
process_poll(handle, timeout = TIMEOUT_IMMEDIATE)

process_return_code(handle)

process_wait(handle, timeout = TIMEOUT_INFINITE)

TIMEOUT_INFINITE

TIMEOUT_IMMEDIATE
}
\arguments{
\item{handle}{Process handle obtained from \code{spawn_process}.}

\item{timeout}{Optional timeout in milliseconds.}
}
\value{
\code{process_poll} returns one of these values:
\code{"not-started"}. \code{"running"}, \code{"exited"},
\code{"terminated"}.
}
\description{
These functions give access to the state of the child process and to
its exit status (return code).

The \code{timeout} parameter can take one of three values:
\itemize{
  \item \code{0} which means no timeout
  \item \code{-1} which means "wait until there is data to read"
  \item a positive integer, which is the actual timeout in milliseconds
}

\code{TIMEOUT_INFINITE} denotes an "infinite" timeout
(that is, wait until response is available) when waiting for an
operation to complete.

\code{TIMEOUT_IMMEDIATE} denotes an "immediate" timeout
(in other words, no timeout) when waiting for an operation to
complete.
}
\details{
\code{process_poll} checks the state of the child process.

\code{process_return_code} complements \code{process_poll}
by giving access to the child process' exit status (return code). If
\code{process_poll} returns neither \code{"exited"} nor
\code{"terminated"}, \code{process_return_code} returns \code{NA}.

\code{process_wait} combined \code{process_poll} and
\code{process_return_code}. It firsts for the process to exit and
then returns its exit code.
}
\seealso{
\code{\link{spawn_process}}, \code{\link{process_read}}
         \code{\link{signals}}
}
\keyword{datasets}

