% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxygen-examples.R
\name{style_roxygen_code_example_segment}
\alias{style_roxygen_code_example_segment}
\title{Style a roxygen code example segment}
\usage{
style_roxygen_code_example_segment(one_dont, transformers, base_indention)
}
\arguments{
\item{one_dont}{Bare R code containing at most one \verb{\\\dontrun{...}} or
friends.}

\item{transformers}{Passed to \code{\link[=cache_make_key]{cache_make_key()}} to generate
a key.}

\item{base_indention}{Integer scalar indicating by how many spaces the whole
output text should be indented. Note that this is not the same as splitting
by line and add a \code{base_indention} spaces before the code in the case
multi-line strings are present. See 'Examples'.}
}
\description{
A roxygen code example segment corresponds to roxygen example code that
contains at most one \verb{\\\dontrun{...}} or friends.
We drop all newline characters first because otherwise the code segment
passed to this function was previously parsed with \code{\link[=parse_roxygen]{parse_roxygen()}} and
line-breaks in and after the \verb{\\\dontrun{...}} are expressed with \code{"\\n"}, which
contradicts to the definition used elsewhere in this package, where every
element in a vector corresponds to a line. These line-breaks don't get
eliminated because they move to the front of a \code{code_segment} and
\code{style_text("\\n1")} gives \code{"\\n1"}, i.e. trailing newlines are not
eliminated.
}
\section{Hierarchy}{

Styling involves splitting roxygen example code into segments, and segments
into snippets. This describes the process for input of
\code{\link[=parse_transform_serialize_roxygen]{parse_transform_serialize_roxygen()}}:
\itemize{
\item Splitting code into roxygen example code and other code. Downstream,
we are only concerned about roxygen code. See
\code{\link[=parse_transform_serialize_roxygen]{parse_transform_serialize_roxygen()}}.
\item Every roxygen example code can have zero or more
dontrun / dontshow / donttest sequences. We next create segments of roxygen
code examples that contain at most one of these. See
\code{\link[=style_roxygen_code_example]{style_roxygen_code_example()}}.
\item We further split the segment that contains at most one dont* sequence into
snippets that are either don* or not. See
\code{\link[=style_roxygen_code_example_segment]{style_roxygen_code_example_segment()}}.
}

Finally, that we have roxygen code snippets that are either dont* or not,
we style them in \code{\link[=style_roxygen_example_snippet]{style_roxygen_example_snippet()}} using
\code{\link[=parse_transform_serialize_r]{parse_transform_serialize_r()}}.
}

\keyword{internal}
