% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styler.R
\docType{package}
\name{styler-package}
\alias{styler}
\alias{styler-package}
\title{Non-invasive pretty printing of R code}
\description{
styler allows you to format .R files, packages or entire R source trees
according to a style guide.
The following functions can be used for styling:
\itemize{
\item \code{\link[=style_text]{style_text()}} to style a character vector.
\item \code{\link[=style_file]{style_file()}} to style a single .R file.
\item \code{\link[=style_dir]{style_dir()}} to style all .R files in a directory.
\item \code{\link[=style_pkg]{style_pkg()}} to style the source files of an R package.
\item \link{styler_addins} (RStudio Addins) to style either selected code or the
active file.
}
}
\examples{
style_text("call( 1)")
style_text("1    + 1", strict = FALSE)
style_text("a\%>\%b", scope = "spaces")
style_text("a\%>\%b; a", scope = "line_breaks")
style_text("a\%>\%b; a", scope = "tokens")
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/r-lib/styler}
  \item \url{https://r-lib.github.io/styler/}
  \item Report bugs at \url{https://github.com/r-lib/styler/issues}
}

}
\author{
\strong{Maintainer}: Lorenz Walthert \email{lorenz.walthert@icloud.com}

Authors:
\itemize{
  \item Kirill Müller \email{krlmlr+r@mailbox.org}
}

}
