\name{modelDropout_gui}
\alias{modelDropout_gui}
\title{model and plot drop-out events}
\usage{
modelDropout_gui(env = parent.frame(), savegui = NULL, debug = FALSE)
}
\arguments{
  \item{env}{environment in wich to search for data frames
  and save result.}

  \item{savegui}{logical indicating if GUI settings should
  be saved in the environment.}

  \item{debug}{logical indicating printing debug
  information.}
}
\description{
\code{modelDropout_gui} model probability of drop-out and
plots a graph.
}
\details{
Models the probability of drop-out P(D) using logistic
regression P(D|H) = B0 + B1*H, where 'H' is the peak height
or log(peak height). Produce a plot showing the model
prediction.

NB! There are several methods of scoring drop-out events
for regression. Currently the 'MethodX', 'Method1', and
'Method2' are endorsed by the DNA commission (see Appendix
B in ref 1). However, an alternative method is to consider
the whole locus and score drop-out if any allele is
missing.

Explanation of the methods: Dropout - all alleles are
scored according to LDT. This is pure observations and is
not used for modelling. MethodX - a random reference allele
is selected and drop-out is scored in relation to the the
partner allele. Method1 - the low molecular weight allele
is selected and drop-out is scored in relation to the
partner allele. Method2 - the high molecular weight allele
is selected and drop-out is scored in relation to the
partner allele. MethodL - drop-out is scored per locus i.e.
drop-out if any allele has dropped out.

Method X/1/2 records the peak height of the partner allele
to be used as the explanatory variable in the logistic
regression. The locus method L also do this when there has
been a drop-out, if not the the mean peak height for the
locus is used. Peak heights for the locus method are stored
in a separate column.
}
\references{
Peter Gill et.al., DNA commission of the International
Society of Forensic Genetics: Recommendations on the
evaluation of STR typing results that may include drop-out
and/or drop-in using probabilistic methods, Forensic
Science International: Genetics, Volume 6, Issue 6,
December 2012, Pages 679-688, ISSN 1872-4973,
10.1016/j.fsigen.2012.06.002.
\url{http://www.sciencedirect.com/science/article/pii/S1872497312001354}

Peter Gill, Roberto Puch-Solis, James Curran, The
low-template-DNA (stochastic) threshold-Its determination
relative to risk analysis for national DNA databases,
Forensic Science International: Genetics, Volume 3, Issue
2, March 2009, Pages 104-111, ISSN 1872-4973,
10.1016/j.fsigen.2008.11.009.
\url{http://www.sciencedirect.com/science/article/pii/S1872497308001798}
}

