% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str_split.R
\name{str_split_fixed}
\alias{str_split_fixed}
\title{Split up a string into pieces}
\source{
Adapted from the \href{https://stringr.tidyverse.org/}{stringr} package.
}
\usage{
str_split_fixed(string, pattern, n)
}
\arguments{
\item{string}{Input vector.
Either a character vector, or something coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression,
as described in \link[base:regex]{base::regex}.
Control options with \code{\link[=regex]{regex()}}.

Match a fixed string (i.e. by comparing only bytes), using \code{\link[=fixed]{fixed()}}.
This is fast, but approximate.}

\item{n}{Maximum number of pieces to return.
This determines the number of columns in the output;
if an input is too short, the result will be padded with \code{""}.}
}
\value{
A character matrix with \code{n} columns and
the same number of rows as the length of \code{string}/\code{pattern}.
}
\description{
Dependency-free drop-in alternative for \code{stringr::str_split_fixed()}.
}
\author{
Eli Pousson \email{eli.pousson@gmail.com}
(\href{https://orcid.org/0000-0001-8280-1706}{ORCID})

Alexander Rossell Hayes \email{alexander@rossellhayes.com}
(\href{https://orcid.org/0000-0001-9412-0457}{ORCID})
}
