% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap.r
\name{str_wrap}
\alias{str_wrap}
\title{Wrap strings into nicely formatted paragraphs.}
\usage{
str_wrap(string, width = 80, indent = 0, exdent = 0)
}
\arguments{
\item{string}{character vector of strings to reformat.}

\item{width}{positive integer giving target line width in characters. A
width less than or equal to 1 will put each word on its own line.}

\item{indent}{non-negative integer giving indentation of first line in
each paragraph}

\item{exdent}{non-negative integer giving indentation of following lines in
each paragraph}
}
\value{
A character vector of re-wrapped strings.
}
\description{
This is a wrapper around \code{\link[stringi:stri_wrap]{stringi::stri_wrap()}} which implements
the Knuth-Plass paragraph wrapping algorithm.
}
\examples{
thanks_path <- file.path(R.home("doc"), "THANKS")
thanks <- str_c(readLines(thanks_path), collapse = "\n")
thanks <- word(thanks, 1, 3, fixed("\n\n"))
cat(str_wrap(thanks), "\n")
cat(str_wrap(thanks, width = 40), "\n")
cat(str_wrap(thanks, width = 60, indent = 2), "\n")
cat(str_wrap(thanks, width = 60, exdent = 2), "\n")
cat(str_wrap(thanks, width = 0, exdent = 2), "\n")
}
