% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_calendar.R
\name{stri_datetime_create}
\alias{stri_datetime_create}
\title{Create a Date-Time Object}
\usage{
stri_datetime_create(
  year,
  month,
  day,
  hour = 12L,
  minute = 0L,
  second = 0,
  lenient = FALSE,
  tz = NULL,
  locale = NULL
)
}
\arguments{
\item{year}{integer vector; 0 is 1BC, -1 is 2BC, etc.}

\item{month}{integer vector; months are 1-based}

\item{day}{integer vector}

\item{hour}{integer vector}

\item{minute}{integer vector}

\item{second}{numeric vector; fractional seconds are allowed}

\item{lenient}{single logical value; should the operation be lenient?}

\item{tz}{\code{NULL} or \code{''} for the default time zone or
a single string with time zone identifier, see \code{\link{stri_timezone_list}}}

\item{locale}{\code{NULL} or \code{''} for default locale,
or a single string with locale identifier; a non-Gregorian calendar
may be specified by setting \code{@calendar=name} keyword}
}
\value{
Returns an object of class \code{\link{POSIXct}}.
}
\description{
Constructs date-time objects from numeric representations.
}
\details{
Vectorized over \code{year}, \code{month}, \code{day}, \code{hour},
\code{hour}, \code{minute}, and \code{second}.
}
\examples{
stri_datetime_create(2015, 12, 31, 23, 59, 59.999)
stri_datetime_create(5775, 8, 1, locale='@calendar=hebrew') # 1 Nisan 5775 -> 2015-03-21
stri_datetime_create(2015, 02, 29)
stri_datetime_create(2015, 02, 29, lenient=TRUE)

}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Other datetime: 
\code{\link{stri_datetime_add}()},
\code{\link{stri_datetime_fields}()},
\code{\link{stri_datetime_format}()},
\code{\link{stri_datetime_fstr}()},
\code{\link{stri_datetime_now}()},
\code{\link{stri_datetime_symbols}()},
\code{\link{stri_timezone_get}()},
\code{\link{stri_timezone_info}()},
\code{\link{stri_timezone_list}()}
}
\concept{datetime}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
