% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgrams.R
\name{seq_qgrams}
\alias{seq_qgrams}
\title{Get a table of qgram counts for integer sequences}
\usage{
seq_qgrams(..., .list = NULL, q = 1L)
}
\arguments{
\item{...}{Any number of (named) arguments that will be coerced with \code{as.integer}}

\item{.list}{Will be concatenated with the \code{...} argument(s). Useful for adding integer vectors named 'q'.}

\item{q}{The size of q-gramming.}
}
\value{
A \code{matrix} containing q-gram profiles. Columns 1 to \code{q} contain the
encountered q-grams. The ensuing (named) columns contain the q-gram counts
per vector. Run the example for a simple overview.

Missing values in integer sequences are treated as any other number.
}
\description{
Get a table of qgram counts for integer sequences
}
\examples{

# compare the 2-gram overlap between sequences 1:3 and 2:4
seq_qgrams(x = 1:3, y=2:4,q=2)

# behavior when NA's are present.
seq_qgrams(1:3,c(1,NA,2),NA_integer_)
}
\seealso{
\code{\link{seq_dist}}, \code{\link{seq_amatch}}
}
