% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streambugs_aux.r
\name{streambugs.get.sys.def}
\alias{streambugs.get.sys.def}
\title{Get system definition of the streambugs ODE model}
\usage{
streambugs.get.sys.def(y.names, par, inp = NA)
}
\arguments{
\item{y.names}{state variables names, either as a vector encoded in the form
\code{"Reach_Habitat_Taxon"} or \code{"Reach_Habitat_Taxon_Group"}, or
a list as returned by \code{\link{decode.statevarnames}} function}

\item{par}{vector with constant parameters and model inputs}

\item{inp}{list with time-dependent parameters or model inputs with one list
element for each parameter or input that includes a matrix where first
column is the time and second the corresponding parameter or input value}
}
\value{
List with definition of the model including input state variables,
   parameters, and inputs, as well as the derived model structure including
   global parameters, environmental conditions of reaches and habitats,
   initial conditions, taxa properties, stoichiometric coefficients of all
   processes, and process definitions for each state variable.
}
\description{
Get a structured representation of the streambugs ODE system definition.
}
\examples{
m <- streambugs.example.model.toy()
sys.def <- streambugs.get.sys.def(y.names=m$y.names, par=m$par, inp=m$inp)
# Get inital conditions for all state variables
sys.def$par.initcond$parvals
# Get stoichiometric coefficients of consumption within the food web
sys.def$par.stoich.web$Cons
# Get stoichiometric coefficients of death process for each taxon
# (transforming them into a dead organic matter "POM")
sys.def$par.stoich.taxon$Death

}
