/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.outliers.AnyOut;

import java.util.ArrayList;
import java.util.HashMap;
import moa.clusterers.clustree.ClusKernel;
import moa.clusterers.clustree.ClusTree;
import moa.clusterers.clustree.Entry;
import moa.clusterers.clustree.Node;
import moa.clusterers.outliers.AnyOut.util.DataObject;
import moa.clusterers.outliers.AnyOut.util.DataSet;
import moa.options.FlagOption;
import moa.options.FloatOption;
import moa.options.IntOption;
import weka.core.DenseInstance;

public class AnyOutCore
extends ClusTree {
    private HashMap<Integer, Double> aggregatedOScoreResult;
    private HashMap<Integer, Double> lastOScoreResult;
    private HashMap<Integer, Double> lastConfidenceResult;
    private HashMap<Integer, ClusKernel> objectAsKernel;
    private HashMap<Integer, ArrayList<Double>> previousOScoreResultList;
    private HashMap<Integer, Node> descendToNode;
    private HashMap<Integer, Integer> currentLevel;
    private double threshold;
    private double weightThreshold = 0.05;
    private int oScoreK;
    private int confK;
    public IntOption trainingSetSizeOption = new IntOption("TrainingSetSize", 't', "Training Set Size.", 1000, 0, 10000);
    public IntOption oScoreKOption = new IntOption("OScorek", 'o', "Size of Oscore aggregate.", 2, 1, 10);
    public IntOption confKOption = new IntOption("Confidencek", 'c', "Size of confidence aggregate.", 2, 1, 10);
    public IntOption confidenceChoiceOption = new IntOption("confidence", 'd', "Confidence Measure.", 4, 1, 6);
    public FlagOption UseMeanScoreOption = new FlagOption("UseMeanScore", 'm', "Use Mean score or Density score.");
    public FloatOption threshholdOption = new FloatOption("Threshold", 'z', "Threshold", 0.07, 0.0, 1.0);

    public AnyOutCore() {
        this.lastOScoreResult = new HashMap();
        this.lastConfidenceResult = new HashMap();
        this.objectAsKernel = new HashMap();
        this.aggregatedOScoreResult = new HashMap();
        this.previousOScoreResultList = new HashMap();
        this.descendToNode = new HashMap();
        this.currentLevel = new HashMap();
    }

    public void resetLearning() {
        this.threshold = this.UseMeanScoreOption.isSet() ? this.threshholdOption.getValue() : 0.0;
        this.oScoreK = this.oScoreKOption.getValue();
        this.confK = this.confKOption.getValue();
        super.resetLearningImpl();
    }

    public void train(DataSet trainingSet) {
        for (DataObject o : trainingSet.getDataObjectArray()) {
            DenseInstance inst = new DenseInstance(o.getFeatures().length);
            for (int i = 0; i < o.getFeatures().length; ++i) {
                inst.setValue(i, o.getFeatures()[i]);
            }
            this.trainOnInstance(inst);
        }
    }

    public void initObject(int objectId, double[] features) {
        this.previousOScoreResultList.put(objectId, new ArrayList());
        this.currentLevel.put(objectId, 0);
        ClusKernel newKernel = new ClusKernel(features, features.length);
        this.objectAsKernel.put(objectId, newKernel);
        Entry closestEntry = this.root.nearestEntry(newKernel);
        if (this.UseMeanScoreOption.isSet()) {
            this.lastOScoreResult.put(objectId, newKernel.calcDistance(closestEntry.data));
        } else {
            this.lastOScoreResult.put(objectId, this.getDensityOutlierScore(newKernel, closestEntry.data));
        }
        this.aggregatedOScoreResult.put(objectId, this.lastOScoreResult.get(objectId));
        this.descendToNode.put(objectId, closestEntry.getChild());
        this.updateConfidence(objectId);
    }

    public void learnObject(double[] features) {
        DenseInstance inst = new DenseInstance(features.length);
        for (int i = 0; i < features.length; ++i) {
            inst.setValue(i, features[i]);
        }
        this.trainOnInstance(inst);
    }

    public void removeObject(int objectId) {
        this.lastOScoreResult.remove(objectId);
        this.lastConfidenceResult.remove(objectId);
        this.aggregatedOScoreResult.remove(objectId);
        this.previousOScoreResultList.remove(objectId);
        this.descendToNode.remove(objectId);
        this.objectAsKernel.remove(objectId);
        this.currentLevel.remove(objectId);
    }

    private double getDensityOutlierScore(ClusKernel x, ClusKernel entry) {
        double[] sigmaSquared = entry.getVarianceVector();
        double resultDensity = 0.0;
        double exponent = 0.0;
        double[] mu = entry.getCenter();
        double factor = Math.pow(Math.PI * 2, (double)sigmaSquared.length / 2.0);
        for (int i = 0; i < sigmaSquared.length; ++i) {
            factor *= Math.sqrt(sigmaSquared[i]);
            exponent += (x.LS[i] - mu[i]) * (x.LS[i] - mu[i]) / sigmaSquared[i];
        }
        factor = 1.0 / factor;
        resultDensity = factor * Math.exp(exponent *= -0.5);
        return 1.0 - resultDensity;
    }

    private void useAggregatedOScoreResults(int objectId) {
        if (this.oScoreK <= 1) {
            this.aggregatedOScoreResult.put(objectId, this.lastOScoreResult.get(objectId));
        } else {
            double mu = this.lastOScoreResult.get(objectId);
            int count = 0;
            for (int i = Math.max(0, this.previousOScoreResultList.get(objectId).size() - (this.oScoreK - 1)); i < this.previousOScoreResultList.get(objectId).size(); ++i) {
                Double d = this.previousOScoreResultList.get(objectId).get(i);
                mu += d.doubleValue();
                ++count;
            }
            this.aggregatedOScoreResult.put(objectId, mu / (double)(count + 1));
        }
    }

    public boolean moreImprovementsPossible(int objectId, double depthPercentage) {
        return (double)this.currentLevel.get(objectId).intValue() < (double)this.maxHeight * depthPercentage && this.descendToNode.get(objectId) != null;
    }

    public void improveObjectOnce(int objectId) {
        this.currentLevel.put(objectId, this.currentLevel.get(objectId) + 1);
        ClusKernel mKernel = this.objectAsKernel.get(objectId);
        this.previousOScoreResultList.get(objectId).add(new Double(this.lastOScoreResult.get(objectId)));
        Entry closestEntry = this.descendToNode.get(objectId).nearestEntry(mKernel);
        if (closestEntry.data.getWeight() < this.weightThreshold) {
            this.descendToNode.remove(objectId);
        } else {
            if (this.UseMeanScoreOption.isSet()) {
                this.lastOScoreResult.put(objectId, mKernel.calcDistance(closestEntry.data));
            } else {
                this.lastOScoreResult.put(objectId, this.getDensityOutlierScore(mKernel, closestEntry.data));
            }
            this.useAggregatedOScoreResults(objectId);
            this.descendToNode.put(objectId, closestEntry.getChild());
            this.updateConfidence(objectId);
        }
    }

    private double calcC1(int objectId) {
        int nrOfPreviousResults = this.previousOScoreResultList.get(objectId).size();
        if (nrOfPreviousResults == 0) {
            return 0.0;
        }
        int count = 1;
        double difSum_k = Math.abs(this.lastOScoreResult.get(objectId) - this.previousOScoreResultList.get(objectId).get(nrOfPreviousResults - 1));
        for (int i = Math.max(0, nrOfPreviousResults - (this.confK - 1)) + 1; i < nrOfPreviousResults; ++i) {
            difSum_k += Math.abs(this.previousOScoreResultList.get(objectId).get(i) - this.previousOScoreResultList.get(objectId).get(i - 1));
            ++count;
        }
        return Math.pow(Math.E, -1.0 * (difSum_k /= (double)count));
    }

    private double calcC2(int objectId) {
        int nrOfPreviousResults = this.previousOScoreResultList.get(objectId).size();
        int count = 1;
        double sum_k = this.lastOScoreResult.get(objectId);
        for (int i = Math.max(0, nrOfPreviousResults - (this.confK - 1)); i < nrOfPreviousResults; ++i) {
            sum_k += this.previousOScoreResultList.get(objectId).get(i).doubleValue();
            ++count;
        }
        return Math.pow(Math.E, -1.0 * (sum_k /= (double)count));
    }

    private double calcC3(int objectId) {
        if (this.getHeight() == 0) {
            return 1.0 * (double)this.currentLevel.get(objectId).intValue() / (1.0 * (double)this.maxHeight);
        }
        return 1.0 * (double)this.currentLevel.get(objectId).intValue() / (1.0 * (double)this.getHeight());
    }

    private void updateConfidence(int objectId) {
        int confChoice = this.confidenceChoiceOption.getValue();
        if (confChoice == 1) {
            this.lastConfidenceResult.put(objectId, this.calcC1(objectId));
        }
        if (confChoice == 2) {
            this.lastConfidenceResult.put(objectId, this.calcC2(objectId));
        }
        if (confChoice == 3) {
            this.lastConfidenceResult.put(objectId, this.calcC3(objectId));
        }
        if (confChoice == 4) {
            this.lastConfidenceResult.put(objectId, this.calcC1(objectId) * this.calcC2(objectId));
        }
        if (confChoice == 5) {
            this.lastConfidenceResult.put(objectId, this.calcC1(objectId) * this.calcC3(objectId));
        }
        if (confChoice == 6) {
            this.lastConfidenceResult.put(objectId, this.calcC2(objectId) * this.calcC3(objectId));
        }
        if (confChoice == 7) {
            this.lastConfidenceResult.put(objectId, this.calcC1(objectId) * this.calcC2(objectId) * this.calcC3(objectId));
        }
    }

    public boolean isOutlier(int id) {
        return this.aggregatedOScoreResult.get(id) / this.lastConfidenceResult.get(id) > this.threshold;
    }

    public double getOutlierScore(int id) {
        return this.aggregatedOScoreResult.get(id) / this.lastConfidenceResult.get(id);
    }

    public double getConfidence(int id) {
        return this.lastConfidenceResult.get(id);
    }
}

