% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSF_Scale.R
\name{DSF_Scale}
\alias{DSF_Scale}
\title{Scale a Data Stream}
\usage{
DSF_Scale(dsd = NULL, dim = NULL, center = TRUE, scale = TRUE, n = 100L)
}
\arguments{
\item{dsd}{A object of class \link{DSD} that will be scaled.}

\item{dim}{integer vector or names of dimensions that should be scaled? Default is all.}

\item{center, scale}{logical or a numeric vector of length equal to the
number of columns (selected with dim) used for centering/scaling (see function \link{scale}).}

\item{n}{The number of points used by \code{scale_stream()} to creating the centering/scaling}
}
\value{
An object of class \code{DSF_Scale} (subclass of \link{DSF} and \link{DSD}).
}
\description{
Make an unscaled data stream into a scaled data stream.
}
\details{
If \code{center} and \code{scale} are not vectors with scaling factors, then \code{scale_stream()}
estimates the values for centering and scaling (see
\link{scale} in \pkg{base}) using \code{n} points from the stream and the stream is reset if \code{reset = TRUE} and the
\link{DSD} object supports resetting.
}
\section{Deprecated}{

\code{DSD_ScaleStream} is deprecated. Use \code{DSF_Scale} instead.
}

\examples{
stream <- DSD_Gaussians(k = 3, d = 2)
get_points(stream, 3)

# scale with manually calculated scaling factors
points <- get_points(stream, n = 100, info = FALSE)
center <- colMeans(points)
scale <- apply(points, MARGIN = 2, sd)

scaledStream <- stream \%>\%  DSF_Scale(dim = c(1L, 2L), center = center, scale = scale)
colMeans(get_points(scaledStream, n = 100, info = FALSE))
apply(get_points(scaledStream, n = 100, info = FALSE), MARGIN = 2, sd)

# let DSF_Scale calculate the scaling factors from the first n points of the stream
scaledStream <- stream \%>\% DSF_Scale(dim = c(1L, 2L), n = 100)
colMeans(get_points(scaledStream, n = 100, info = FALSE))
apply(get_points(scaledStream, n = 100, info = FALSE), MARGIN = 2, sd)

## scale only X2
scaledStream <- stream \%>\% DSF_Scale(dim = "X2", n = 100)
colMeans(get_points(scaledStream, n = 100, info = FALSE))
apply(get_points(scaledStream, n = 100, info = FALSE), MARGIN = 2, sd)
}
\seealso{
\link{scale} in \pkg{base}

Other DSF: 
\code{\link{DSF_Convolve}()},
\code{\link{DSF_Downsample}()},
\code{\link{DSF_ExponentialMA}()},
\code{\link{DSF_Func}()},
\code{\link{DSF_dplyr}()},
\code{\link{DSF}()}
}
\author{
Michael Hahsler
}
\concept{DSF}
