/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers;

import java.util.LinkedList;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Classifier;
import moa.core.DoubleVector;
import moa.core.Measurement;
import moa.options.ClassOption;
import moa.options.FloatOption;
import moa.options.MultiChoiceOption;
import weka.core.Instance;
import weka.core.Utils;

public class ActiveClassifier
extends AbstractClassifier {
    private static final long serialVersionUID = 1L;
    public ClassOption baseLearnerOption = new ClassOption("baseLearner", 'l', "Classifier to train.", Classifier.class, "SingleClassifierDrift");
    public MultiChoiceOption activeLearningStrategyOption = new MultiChoiceOption("activeLearningStrategy", 'd', "Active Learning Strategy to use.", new String[]{"Random", "FixedUncertainty", "VarUncertainty", "RandVarUncertainty", "SelSampling"}, new String[]{"Random strategy", "Fixed uncertainty strategy", "Uncertainty strategy with variable threshold", "Uncertainty strategy with randomized variable threshold", "Selective Sampling"}, 0);
    public FloatOption budgetOption = new FloatOption("budget", 'b', "Budget to use.", 0.1, 0.0, 1.0);
    public FloatOption fixedThresholdOption = new FloatOption("fixedThreshold", 'u', "Fixed threshold.", 0.9, 0.0, 1.0);
    public FloatOption stepOption = new FloatOption("step", 's', "Floating budget step.", 0.01, 0.0, 1.0);
    public FloatOption numInstancesInitOption = new FloatOption("numInstancesInit", 'n', "Number of instances at beginning without active learning.", 0.0, 0.0, 2.147483647E9);
    public Classifier classifier;
    public int costLabeling;
    public int costLabelingRandom;
    public int iterationControl;
    public double newThreshold;
    public double maxPosterior;
    public double accuracyBaseLearner;
    private double outPosterior;

    private double getMaxPosterior(double[] incomingPrediction) {
        if (incomingPrediction.length > 1) {
            DoubleVector vote = new DoubleVector(incomingPrediction);
            if (vote.sumOfValues() > 0.0) {
                vote.normalize();
            }
            incomingPrediction = vote.getArrayRef();
            this.outPosterior = incomingPrediction[Utils.maxIndex(incomingPrediction)];
        } else {
            this.outPosterior = 0.0;
        }
        return this.outPosterior;
    }

    private void labelRandom(Instance inst) {
        if (this.classifierRandom.nextDouble() < this.budgetOption.getValue()) {
            this.classifier.trainOnInstance(inst);
            ++this.costLabeling;
            ++this.costLabelingRandom;
        }
    }

    private void labelFixed(double incomingPosterior, Instance inst) {
        if (incomingPosterior < this.fixedThresholdOption.getValue()) {
            this.classifier.trainOnInstance(inst);
            ++this.costLabeling;
        }
    }

    private void labelVar(double incomingPosterior, Instance inst) {
        if (incomingPosterior < this.newThreshold) {
            this.classifier.trainOnInstance(inst);
            ++this.costLabeling;
            this.newThreshold *= 1.0 - this.stepOption.getValue();
        } else {
            this.newThreshold *= 1.0 + this.stepOption.getValue();
        }
    }

    private void labelSelSampling(double incomingPosterior, Instance inst) {
        double p = Math.abs(incomingPosterior - 1.0 / (double)inst.numClasses());
        double budget = this.budgetOption.getValue() / (this.budgetOption.getValue() + p);
        if (this.classifierRandom.nextDouble() < budget) {
            this.classifier.trainOnInstance(inst);
            ++this.costLabeling;
        }
    }

    public void resetLearningImpl() {
        this.classifier = ((Classifier)this.getPreparedClassOption(this.baseLearnerOption)).copy();
        this.classifier.resetLearning();
        this.costLabeling = 0;
        this.costLabelingRandom = 0;
        this.iterationControl = 0;
        this.newThreshold = 1.0;
        this.accuracyBaseLearner = 0.0;
    }

    public void trainOnInstanceImpl(Instance inst) {
        ++this.iterationControl;
        double costNow = (double)this.iterationControl <= this.numInstancesInitOption.getValue() ? 0.0 : ((double)this.costLabeling - this.numInstancesInitOption.getValue()) / ((double)this.iterationControl - this.numInstancesInitOption.getValue());
        if (costNow < this.budgetOption.getValue()) {
            switch (this.activeLearningStrategyOption.getChosenIndex()) {
                case 0: {
                    this.labelRandom(inst);
                    break;
                }
                case 1: {
                    this.maxPosterior = this.getMaxPosterior(this.classifier.getVotesForInstance(inst));
                    this.labelFixed(this.maxPosterior, inst);
                    break;
                }
                case 2: {
                    this.maxPosterior = this.getMaxPosterior(this.classifier.getVotesForInstance(inst));
                    this.labelVar(this.maxPosterior, inst);
                    break;
                }
                case 3: {
                    this.maxPosterior = this.getMaxPosterior(this.classifier.getVotesForInstance(inst));
                    this.maxPosterior /= this.classifierRandom.nextGaussian() + 1.0;
                    this.labelVar(this.maxPosterior, inst);
                    break;
                }
                case 4: {
                    this.maxPosterior = this.getMaxPosterior(this.classifier.getVotesForInstance(inst));
                    this.labelSelSampling(this.maxPosterior, inst);
                }
            }
        }
    }

    public double[] getVotesForInstance(Instance inst) {
        return this.classifier.getVotesForInstance(inst);
    }

    public boolean isRandomizable() {
        return true;
    }

    public void getModelDescription(StringBuilder out, int indent) {
        ((AbstractClassifier)this.classifier).getModelDescription(out, indent);
    }

    protected Measurement[] getModelMeasurementsImpl() {
        LinkedList<Measurement> measurementList = new LinkedList<Measurement>();
        measurementList.add(new Measurement("labeling cost", this.costLabeling));
        measurementList.add(new Measurement("newThreshold", this.newThreshold));
        measurementList.add(new Measurement("maxPosterior", this.maxPosterior));
        measurementList.add(new Measurement("accuracyBaseLearner (percent)", 100.0 * this.accuracyBaseLearner / (double)this.costLabeling));
        Measurement[] modelMeasurements = ((AbstractClassifier)this.classifier).getModelMeasurementsImpl();
        if (modelMeasurements != null) {
            for (Measurement measurement : modelMeasurements) {
                measurementList.add(measurement);
            }
        }
        return measurementList.toArray(new Measurement[measurementList.size()]);
    }
}

