% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.matrix.gtypes.R
\docType{methods}
\name{as.matrix,gtypes-method}
\alias{as.matrix,gtypes-method}
\alias{as.matrix.gtypes}
\alias{as.matrix}
\title{Convert \code{gtypes} To \code{matrix}}
\usage{
\S4method{as.matrix}{gtypes}(x, one.col = FALSE, sep = "/", ids = TRUE,
  strata = TRUE, sort.alleles = TRUE, ...)
}
\arguments{
\item{x}{a \linkS4class{gtypes} object.}

\item{one.col}{logical. If \code{TRUE}, then result has one column per 
locus.}

\item{sep}{character to use to separate alleles if \code{one.col} is 
\code{TRUE}.}

\item{ids}{logical. include a column for individual identifiers (\code{ids})?}

\item{strata}{logical. include a column for current statification (\code{strata})?}

\item{sort.alleles}{logical. for non-haploid objects, should alleles be sorted 
in genotypes or left as in original order? (only takes affect if \code{one.col = TRUE})}

\item{...}{additional arguments to be passed to or from methods.}
}
\value{
A \code{matrix} with one row per sample.
}
\description{
Create a matrix from a \linkS4class{gtypes} object.
}
\examples{
data(msats.g)

# with defaults (alleles in multiple columns, with ids and stratification)
mat <- as.matrix(msats.g)
head(mat)

# one column per locus
onecol.mat <- as.matrix(msats.g, one.col = TRUE)
head(onecol.mat)

# just the genotypes
genotypes.mat <- as.matrix(msats.g, one.col = TRUE, ids = FALSE, strata = FALSE)
head(genotypes.mat)

}
\seealso{
\link{df2gtypes} \link[strataG]{as.data.frame} \link[strataG]{as.array}
}
\author{
Eric Archer \email{eric.archer@noa.gov}
}
