library(stratEst)

test_that("SFEM for treatment 1, Dal Bo & Frechette 2011",  {
  strats <- rbind(ALLD,ALLC,GRIM,TFT,WSLS,T2)
  # treatment 1
  set.seed(1)
  sfem1 <- stratEst(DF2011[DF2011[,1]==1,],strats,print.messages = F)
  estimated_shares <- round(sfem1$shares,3)
  estimated_trembles <- round(sfem1$trembles,2)
  estimated_ses <- round(sfem1$shares.se,3)
  estimated_trembles_ses <- round(sfem1$trembles.se,3)
  expect_equal(0.920,estimated_shares[1])
  expect_equal(0.080,estimated_shares[4])
  expect_equal(0.043,estimated_ses[1])
  expect_equal(0.043,estimated_ses[4])
  expect_equal(round(1 - 1/(1+exp(-1/0.362)),2),estimated_trembles[1])
})


# # treatment 2
# set.seed(1)
# sfem2 <- stratEst(DF2011[DF2011[,1]==2,],strats,select = "strategies", crit ="aic", se= "bs")
# estimated_shares <- round(sfem2$shares,3)
# estimated_trembles <- round(sfem2$trembles,3)
# estimated_ses <- round(sfem2$shares_SE,3)
# estimated_trembles_ses <- round(sfem2$trembles_SE,3)
# expect_equal(0.783,estimated_shares[1])
# expect_equal(0.078,estimated_shares[2])
# expect_equal(0.040,estimated_shares[3])
# expect_equal(0.098,estimated_shares[4])
# expect_equal(0.060,estimated_ses[1])
# expect_equal(0.042,estimated_ses[2])
# expect_equal(0.029,estimated_ses[3])
# expect_equal(0.045,estimated_ses[4])
# expect_equal(0.136,estimated_trembles[1])
# expect_equal(0.023,estimated_trembles_ses[1])
# # treatment 3
# set.seed(1)
# sfem3 <- stratEst(DF2011[DF2011[,1]==3,],strats,select = "strategies", crit ="aic", se= "bs")
# estimated_shares <- round(sfem3$shares,3)
# estimated_trembles <- round(sfem3$trembles,3)
# estimated_ses <- round(sfem3$shares_SE,3)
# estimated_trembles_ses <- round(sfem3$trembles_SE,3)
# expect_equal(0.533,estimated_shares[1])
# expect_equal(0.072,estimated_shares[2])
# expect_equal(0.395,estimated_shares[3])
# expect_equal(0.075,estimated_ses[1])
# expect_equal(0.041,estimated_ses[2])
# expect_equal(0.075,estimated_ses[3])
# expect_equal(0.090,estimated_trembles[1])
# expect_equal(0.019,estimated_trembles_ses[1])
# # treatment 4
# set.seed(1)
# sfem4 <- stratEst(DF2011[DF2011[,1]==4,],strats,select = "strategies", crit ="aic", se= "bs")
# estimated_shares <- round(sfem4$shares,3)
# estimated_trembles <- round(sfem4$trembles,3)
# estimated_ses <- round(sfem4$shares_SE,3)
# estimated_trembles_ses <- round(sfem4$trembles_SE,3)
# expect_equal(0.648,estimated_shares[1])
# expect_equal(0.352,estimated_shares[2])
# expect_equal(0.074,estimated_ses[1])
# expect_equal(0.074,estimated_ses[2])
# expect_equal(0.096,estimated_trembles[1])
# expect_equal(0.018,estimated_trembles_ses[1])
# # treatment 5
# set.seed(1)
# sfem5 <- stratEst(DF2011[DF2011[,1]==5,],strats,select = "strategies", crit ="aic", se= "bs")
# estimated_shares <- round(sfem5$shares,3)
# estimated_trembles <- round(sfem5$trembles,3)
# estimated_ses <- round(sfem5$shares_SE,3)
# estimated_trembles_ses <- round(sfem5$trembles_SE,3)
# expect_equal(0.109,estimated_shares[1])
# expect_equal(0.296,estimated_shares[2])
# expect_equal(0.267,estimated_shares[3])
# expect_equal(0.327,estimated_shares[4])
# expect_equal(0.050,estimated_ses[1])
# expect_equal(0.112,estimated_ses[2])
# expect_equal(0.114,estimated_ses[3])
# expect_equal(0.143,estimated_ses[4])
# expect_equal(0.091,estimated_trembles[1])
# expect_equal(0.031,estimated_trembles_ses[1])
# # # treatment 6
# set.seed(1)
# sfem6 <- stratEst(DF2011[DF2011[,1]==6,],strats,select = "strategies", crit ="aic", se= "bs")
# estimated_shares <- round(sfem6$shares,3)
# estimated_trembles <- round(sfem6$trembles,3)
# estimated_ses <- round(sfem6$shares_SE,3)
# estimated_trembles_ses <- round(sfem6$trembles_SE,3)
# expect_equal(0.076,estimated_shares[1])
# expect_equal(0.606,estimated_shares[2])
# expect_equal(0.319,estimated_shares[3])
# expect_equal(0.073,estimated_ses[1])
# expect_equal(0.150,estimated_ses[2])
# expect_equal(0.154,estimated_ses[3])
# expect_equal(0.030,estimated_trembles[1])
# expect_equal(0.011,estimated_trembles_ses[1])
