% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{is.avector}
\alias{is.avector}
\title{Test for an Atomic Vector}
\usage{
is.avector(x)
}
\arguments{
\item{x}{= object whose structure is desired to be tested.}
}
\value{
logical vector with length 1 specifying whether `x` is an atomic vector.
}
\description{
\code{is.avector} returns whether an object is an atomic vector with typeof
character, logical, integer, or double.
}
\details{
\code{is.avector} is simply a logical "and" of \code{is.atomic} and \code{is.vector}.
}
\examples{
is.avector(x = c(1,2,3))
is.avector(x = array(c(1,2,3))) # returns false for arrays
is.avector(x = list(1,2,3)) # returns false for lists
}
