% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{ld2d}
\alias{ld2d}
\title{List of Data-Frames to Data-Frame}
\usage{
ld2d(
  ld,
  along = 1,
  fill = FALSE,
  rtn.listnames.nm = "list_names",
  rtn.rownames.nm = "row_names",
  stringsAsFactors = FALSE,
  check.names = FALSE,
  check = TRUE
)
}
\arguments{
\item{ld}{list of data.frames.}

\item{along}{integer vector of length 1 specifying which dimension the data.frames
from \code{ld} should be binded along: 1 is for rows and 2 is for columns.}

\item{fill}{logical vector of length 1 specifying whether to fill in missing values
for any data.frames from \code{ld} that do not have all the columns. At this time,
\code{fill} is only available for rbinding and only used if \code{along} = 1.}

\item{rtn.listnames.nm}{character of length 1 specifying what the name of the
column containing the names/positions of \code{ld} should be in the returned
data.frame. If NULL, then no column is created for the names/positions of \code{ld}
in the returned data.frame.}

\item{rtn.rownames.nm}{character of length 1 specifying what the name of the
column containing the rownames of \code{ld}'s data.frames should be in the returned
data.frame. If NULL, then no column is created for the rownames of \code{ld}'s
data.frames in the returned data.frame.}

\item{stringsAsFactors}{logical vector of length 1 specifying whether character columns
from \code{ld} should be converted to factors. Only available and used if \code{fill}
= FALSE.}

\item{check.names}{logical vector of length 1 specifying whether the colnames
of the returned data.frame should be checked for duplicates and made unique.
Only used if for cbinding with \code{along} = 2.}

\item{check}{logical vector of length 1 specifying whether to check the structure
of the input arguments. For example, check whether \code{ld} is a list of data.frames.
This argument is available to allow flexibility in whether the user values
informative error messages (TRUE) vs. computational efficiency (FALSE).}
}
\value{
data.frame with the rows (if \code{along} = 1) or columns (if \code{along}
= 2) of \code{ld} binded together.
}
\description{
\code{ld2d} converts a list of data.frames to a data.frame. The function is
primarily for rbinding a list of data.frames (\code{along} = 1). An option to
cbind the list of data.frames is included (\code{along} = 2), but is just a call to
\code{data.frame(ld, stringsAsFactors = stringsAsFactors, check.names = check.names)}.
}
\examples{
# without listnames and default rownames
ld <- list(BOD*1, BOD*2, BOD*3)
ld2d(ld)
# with listnames and default rownames
names(ld) <- LETTERS[1:3]
ld2d(ld)
# without listnames and custom rownames
ld <- lapply(unname(ld), FUN = `row.names<-`, letters[1:6])
ld2d(ld)
# with listnames and custom rownames
ld <- setNames(ld, LETTERS[1:3])
ld2d(ld)
# can handle same named columns in different positions
ld <- list(BOD*1, rev(BOD*2), rev(BOD*3))
ld2d(ld)
# can handle some columns being absent with fill = TRUE
ld[[2]]$"demand" <- NULL
try_expr(ld2d(ld, fill = FALSE)) # error
ld2d(ld, fill = TRUE) # NAs added
# along = 2 for cbinding
ld2d(ld, along = 2) # does not check/rename for double colnames
ld2d(ld, along = 2, check.names = TRUE) # makes unique colnames
}
