% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artif_spo.R
\name{artif_spo}
\alias{artif_spo}
\title{Artificial spatial origins}
\usage{
artif_spo(poly, n_origin=50, restriction_feat = NULL,
n_foci=5, foci_separation = 10, mfocal = NULL,
conc_type = "nucleated", p_ratio)
}
\arguments{
\item{poly}{(An sf or S4 object)
a polygon shapefile defining the extent
of the landscape}

\item{n_origin}{number of locations to serve as
origins for walkers. Default:\code{50}.}

\item{restriction_feat}{(An S4 object) optional
shapefile containing features
in which walkers cannot walk through.
Default: \code{NULL}.}

\item{n_foci}{number of focal points amongst the origin
locations. The origins to serve as focal
points are based on random selection. \code{n_foci} must be
smaller than \code{n_origins}.}

\item{foci_separation}{a value from \code{1} to \code{100}
indicating the nearness of focal points to one another.
A \code{0} separation indicates that focal points are in
close proximity
of one another, while a \code{100} indicates focal points being
evenly distributed across space.}

\item{mfocal}{the c(x, y) coordinates of a single point,
representing a pre-defined \code{main} focal point (origin)
in the area. The default is \code{NULL} in which a random
coordinate is chosen within the \code{polygon} area.}

\item{conc_type}{concentration of the rest of the
origins (non-focal origins) around the focal ones. The options
are \code{"nucleated"} and \code{"dispersed"}.}

\item{p_ratio}{the smaller of the
two terms of proportional ratios.
For example, a value of \code{20}
implies \code{20:80} proportional ratios.}
}
\value{
Returns a list detailing the
properties of the generated spatial origins
with associated
strength (probability) values.
}
\description{
Simulates spatial locations to serve
as origins of walkers. If provided, spaces covered
by restriction features are avoided. Final
origins are assigned probability values
indicating the strengths of the origins.
}
\details{
The focal origins (\code{n_foci}) serve as the central locations
(such as, city centres). The \code{foci_separation} indicates
the nearness of focal origins from one another.
The \code{conc_type} argument allows a user to specify
the type of spatial concentration exhibited by the non-focal
origin around the focal ones.
If \code{restriction_feat} is provided, its features help
to prevent the occurrence of any events in the areas
occupied by the features.
}
\examples{
#load boundary of Camden
load(file = system.file("extdata", "camden.rda",
package="stppSim"))
boundary = camden$boundary # get boundary
landuse <- camden$landuse
spo <- artif_spo(poly = boundary, n_origin = 50,
restriction_feat = landuse, n_foci=5, foci_separation = 0,
mfocal = NULL, conc_type = "dispersed", p_ratio=20)
}
