% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linefuns.R
\name{line_segment}
\alias{line_segment}
\title{Divide sf LINESTRING objects into regular segments}
\usage{
line_segment(l, n_segments, segment_length = NA)
}
\arguments{
\item{l}{A spatial lines object}

\item{n_segments}{The number of segments to divide the line into}

\item{segment_length}{The approximate length of segments in the output (overides n_segments if set)}
}
\description{
Divide sf LINESTRING objects into regular segments
}
\examples{
l <- routes_fast_sf[2, ]
l_seg2 <- line_segment(l = l, n_segments = 2)
plot(sf::st_geometry(l_seg2), col = 1:2, lwd = 5)
}
\seealso{
Other lines: 
\code{\link{angle_diff}()},
\code{\link{geo_toptail}()},
\code{\link{is_linepoint}()},
\code{\link{line2df}()},
\code{\link{line2points}()},
\code{\link{line_bearing}()},
\code{\link{line_breakup}()},
\code{\link{line_midpoint}()},
\code{\link{line_via}()},
\code{\link{mats2line}()},
\code{\link{n_vertices}()},
\code{\link{onewaygeo}()},
\code{\link{points2line}()},
\code{\link{toptail_buff}()}
}
\concept{lines}
