% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{update_line_geometry}
\alias{update_line_geometry}
\title{Update line geometry}
\usage{
update_line_geometry(l, nl)
}
\arguments{
\item{l}{A SpatialLines object, whose geometry is to be modified}

\item{nl}{A SpatialLines object of the same length as \code{l} to provide the new geometry}
}
\description{
Take two SpatialLines objects and update the geometry of the former with that of the latter,
retaining the data of the former.
}
\examples{
data(flowlines)
l <- flowlines[2:5, ]
nl <- routes_fast
nrow(l)
nrow(nl)
l <- l[!is_linepoint(l), ]
names(l)
names(routes_fast)
l_newgeom <- update_line_geometry(l, nl)
plot(l, lwd = l$All / mean(l$All))
plot(l_newgeom, lwd = l$All / mean(l$All))
names(l_newgeom)
}
\seealso{
Other lines: \code{\link{angle_diff}},
  \code{\link{geo_toptail}}, \code{\link{is_linepoint}},
  \code{\link{line2df}}, \code{\link{line2points}},
  \code{\link{line_bearing}}, \code{\link{line_match}},
  \code{\link{line_midpoint}}, \code{\link{line_sample}},
  \code{\link{line_segment}}, \code{\link{line_via}},
  \code{\link{mats2line}}, \code{\link{n_sample_length}},
  \code{\link{n_vertices}}, \code{\link{onewaygeo}},
  \code{\link{onewayid}}, \code{\link{points2line}},
  \code{\link{toptail_buff}}, \code{\link{toptailgs}}
}
\concept{lines}
