% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo-functions.R
\name{geo_bb}
\alias{geo_bb}
\alias{bb2poly}
\title{Flexible function to generate bounding boxes}
\usage{
geo_bb(shp, scale_factor = 1, distance = 0, output = c("polygon",
  "points", "bb"))
}
\arguments{
\item{shp}{Spatial object (from sf or sp packages)}

\item{scale_factor}{Numeric vector determining how much the bounding box will grow or shrink.
Two numbers refer to extending the bounding box in x and y dimensions, respectively.
If the value is 1, the output size will be the same as the input.}

\item{distance}{Distance in metres to extend the bounding box by}

\item{output}{Type of object returned (polygon by default)}
}
\description{
Takes a geographic object or bounding box as an input and outputs a bounding box,
represented as a bounding box, corner points or rectangular polygon.
}
\examples{
plot(geo_bb(routes_fast, distance = 100), col = "red")
plot(geo_bb(routes_fast, scale_factor = 0.8), col = "green", add = TRUE)
plot(geo_bb(sp::bbox(routes_fast)), add = TRUE) # works on bb also
plot(geo_bb(routes_fast, output = "points"), add = TRUE)
# Simple features implementation:
bb_sf1 <- geo_bb(routes_fast_sf, scale_factor = c(2, 1.5))
bb_sf2 <- geo_bb(routes_fast_sf, c(2, 1.5), distance = 100)
plot(bb_sf1)
plot(bb_sf2, add = TRUE)
plot(routes_fast, add = TRUE)
plot(geo_bb(routes_fast_sf, output = "points"), add = TRUE)
bb_matrix <- geo_bb(routes_fast, scale_factor = c(2, 1.1), output = "bb")
plot(routes_fast_sf[2:5, ], bbox = bb_matrix)
}
\seealso{
bb_scale
}
