% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_funs.R
\name{od_aggregate}
\alias{od_aggregate}
\title{Aggregate OD data between polygon geometries}
\usage{
od_aggregate(flow, zones, aggzones, aggzone_points = NULL, cols = FALSE,
  aggcols = FALSE, FUN = sum, prop_by_area = ifelse(identical(FUN, mean)
  == FALSE, TRUE, FALSE), digits = getOption("digits"))
}
\arguments{
\item{flow}{A data frame representing the flow between two points
or zones. The first two columns of this data frame should correspond
to the first column of the data in the zones. Thus in \code{\link{cents}},
the first column is geo_code. This corresponds to the first two columns
of \code{\link{flow}}.}

\item{zones}{A SpatialPolygonsDataFrame or SpatialPointsDataFrame
representing the original centroids or boundaries of the travel flow data.
Note that in the case of a SpatialPointsDataFrame, the entirety of the flow
will be allocated to the polygon in which the point is located rather than
being distributed by area.}

\item{aggzones}{A SpatialPolygonsDataFrame containing the new
boundaries to aggregate to.}

\item{aggzone_points}{Points representing origins of OD flows
(typically population-weighted centroids)}

\item{cols}{A character vector containing the names of columns on which to
apply FUN. By default, all numeric columns are aggregated.}

\item{aggcols}{A character vector containing the names of columns in
aggzones to retain in the aggregated data.frame. By default,
only the first column is retained. These columns are renamed with a prefix
of "o_" and "d_".}

\item{FUN}{Function to use on aggregation. Default is sum.}

\item{prop_by_area}{Boolean value indicating if the values should be
proportionally adjusted based on area. Default is TRUE unless FUN = mean.}

\item{digits}{The number of digits to use when proportionally adjusting
values based on area. Default is the value of getOption("digits").}
}
\value{
data.frame containing the aggregated od flows.
}
\description{
Aggregate OD data between polygon geometries
}
\section{Details}{

Origin-destination ('OD') flow data is often provided
in the form of 1 line per flow with zone codes of origin and destination
centroids. This function aggregates OD flows between polygon geometries
allocating the original flows to larger zones based on area.
}

\examples{
zones$quadrant = c(1, 2, 1, 4, 5, 6, 7, 1)
aggzones <- rgeos::gUnaryUnion(zones, id = zones@data$quadrant)
aggzones <- sp::SpatialPolygonsDataFrame(aggzones, data.frame(region = c(1:6)), match.ID = FALSE)
sp::proj4string(aggzones) = sp::proj4string(zones)
aggzones_sf <- sf::st_as_sf(aggzones)
aggzones_sf <- sf::st_set_crs(aggzones_sf, sf::st_crs(zones_sf))
od_agg <- od_aggregate(flow, zones_sf, aggzones_sf)
colSums(od_agg[3:9]) == colSums(flow[3:9])
od_sf_agg <- od2line(od_agg, aggzones_sf)
plot(flowlines, lwd = flowlines$Bicycle)
plot(od_sf_agg$geometry, lwd = od_sf_agg$Bicycle, add = TRUE, col = "red")
}
