% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.locstppm.R
\name{summary.locstppm}
\alias{summary.locstppm}
\title{Summary of a fitted local spatio-temporal Poisson process model}
\usage{
\method{summary}{locstppm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{locstppm}}

\item{...}{additional unused argument}
}
\description{
The function summarises the main information on the distribution of the parameters
 of a fitted local spatio-temporal Poisson process model.
}
\examples{

set.seed(2)
inh <- rstpp(lambda = function(x, y, t, a) {exp(a[1] + a[2]*x)}, 
             par = c(0.005, 5))
inh_local <- locstppm(inh, formula = ~ x)

summary(inh_local)



}
\references{
D'Angelo, N., Adelfio, G., and Mateu, J. (2023). Locally weighted minimum contrast estimation for spatio-temporal log-Gaussian Cox processes. Computational Statistics & Data Analysis, 180, 107679.
}
\seealso{
\link{locstppm}, \link{print.locstppm},
\link{plot.locstppm}
}
\author{
Nicoletta D'Angelo
}
