% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{preprocessTrainData}
\alias{preprocessTrainData}
\title{Preprocess Covariates for Model Training}
\usage{
preprocessTrainData(input_data)
}
\arguments{
\item{input_data}{Covariates, provided as either a dataframe or a matrix}
}
\value{
List with preprocessed (unmodified) data and details on the number of each type
of variable, unique categories associated with categorical variables, and the
vector of feature types needed for calls to BART and BCF.
}
\description{
Preprocess covariates for use in a \code{ForestDataset} at train time.
DataFrames will be preprocessed based on their column
types. Matrices will be passed through assuming all columns are numeric.
}
\examples{
cov_mat <- matrix(1:12, ncol = 3)
preprocess_list <- preprocessTrainData(cov_mat)
X <- preprocess_list$X
}
