\name{plot.STMpermute}
\alias{plot.STMpermute}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Plot an STM permutation test.
}
\description{
Plots the results of a permutation test run using \code{\link{permutationTest}}.
}
\usage{
\method{plot}{STMpermute}(x, topic,
                type=c("match", "largest"),
                xlim=NULL, ylim=NULL, ...) 
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
Object from the output of \code{\link{permutationTest}}.
}
  \item{topic}{
   Integer indicating which topic to plot.
}
  \item{type}{
Character string indicating what topic comparison to use. "match" uses the Hungarian aligned method and "largest" uses the largest mean in direction of reference topic.
}
  \item{xlim}{
  Range of the X-axis.
  }
  \item{ylim}{
  Range of the Y-axis.
  }
  \item{...}{
  Other parameters which may be passed to plot.
  }
}
\details{
This function plots the output of \code{\link{permutationTest}} by stacking horizontal confidence intervals for the effects of the permuted variable. 
In choosing the topic in the permuted runs of stm to plot the effect for, two methods are available, "match" and "largest". The former uses Kuhn's (1955) Hungarian method to align the topics, and then uses the model's best match of the reference topic. 
The latter uses the topic which has the expected effect size in the direction of the reference model effect; thus, we would expect this method to be quite conservative.  
}
\seealso{
\code{\link{permutationTest}}
}
\examples{
\dontrun{
temp<-textProcessor(documents=gadarian$open.ended.response,metadata=gadarian)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta)
documents <- out$documents
vocab <- out$vocab
meta <- out$meta
set.seed(02138)
mod.out <- stm(documents, vocab, 3, prevalence=~treatment + s(pid_rep), data=meta)
summary(mod.out)
prep <- estimateEffect(1:3 ~ treatment + s(pid_rep), mod.out, meta)
plot.estimateEffect(prep, "treatment", model=mod.out,
                    method="difference",cov.value1=1,cov.value2=0)
test <- permutationTest(formula=~ treatment + s(pid_rep), stmobj=mod.out, 
                        treatment="treatment", nruns=25, documents=documents,
                        vocab=vocab,data=meta, stmverbose=FALSE)
plot.STMpermute(test,2, xlab="Effect", ylab="Model Index", main="Topic 2 Placebo Test")
}
}
