% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csb_get_data.R
\name{csb_get_data}
\alias{csb_get_data}
\title{Download CSB Data from the City of St. Louis}
\usage{
csb_get_data(tidy = TRUE, years, ...)
}
\arguments{
\item{tidy}{A logical scalar; if \code{TRUE}, variable names will be converted to
lower case and reordered. Two variables with incomplete data - problem city
(\code{PROBCITY}) and problem zip code (\code{PROBZIP}) - are dropped to limit
use of memory. This mirrors the functionality of \link{csb_load_variables}.}

\item{years}{Optional; if included, data not in the specified years will be excluded
from the returned object.}

\item{...}{Additional testing options; not for production use}
}
\value{
Returns a tibble with all CSB calls for service.
}
\description{
\code{csb_get_data} provides direct access to a compiled version
    of the CSB's data release via the City of St. Louis website. These data are
    provided with no warranty from either the City of St. Louis or the package
    developers.
}
\examples{
\dontrun{
csb <- csb_get_data()
csb <- csb_get_data(tidy = FALSE)
csb <- csb_get_data(years = 2009:2018)
csb <- csb_get_data(years = 2018)
}

}
