% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_hawkes.r
\name{sim_hawkes}
\alias{sim_hawkes}
\title{Simulate a self-exciting Hawkes process}
\usage{
sim_hawkes(mu, alpha, beta, n = 100, plot = FALSE, seed = 123, method = "1")
}
\arguments{
\item{mu}{A numeric specifying base rate of the Hawkes process.}

\item{alpha}{A numeric specifying intensity jump after an event
occurrence.}

\item{beta}{A numeric specifying exponential intensity decay}

\item{n}{A numeric depending on method: if \code{method = "1"} specifies
end of the time line within which to simulate the process, 
if \code{method = "2"} specifies the number of observations to simulate.
Default, \code{100}.}

\item{plot}{Logical, if \code{TRUE} data plotted along with the intensity.
Default, \code{FALSE}.}

\item{seed}{The seed. Default, \code{123}}

\item{method}{A character "1" or "2" specifying the method (see details)
to simulate Hawkes process. Default,\code{"1"}.}
}
\value{
A \code{numeric} vector of simulated event times.
}
\description{
Simulates a self-exciting Hawkes process.
}
\details{
Option of two methods to simulate a Hawkes process: 
if \code{method = "1"} then a univariate Hawkes process as 
\code{hawkes::simulateHawkes()} is simulated,
if \code{method = "2"} then an accept/reject
framework is used.
}
\examples{
sim_hawkes(10.2, 3.1, 8.9)
sim_hawkes(10.2, 3.1, 8.9, method = "2")

}
\seealso{
\code{\link{fit_hawkes}}
}
