% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_freq.R
\name{plot_freq}
\alias{plot_freq}
\title{Plot frequencies of a variable, optionally by group (histogram without binning)}
\usage{
plot_freq(
  formula,
  data = NULL,
  freq = TRUE,
  col = "dodgerblue",
  lwd = 9,
  width = NULL,
  value.labels = TRUE,
  add = FALSE,
  show.legend = TRUE,
  legend.title = NULL,
  col.text = NULL,
  ...
)
}
\arguments{
\item{formula}{A formula of the form \code{x ~ group} where \code{x} is the
variable to plot frequencies for and \code{group} is an optional grouping variable
(with 2 or 3 unique values). For single variable (no grouping), use \code{x ~ 1}.}

\item{data}{An optional data frame containing the variables in the formula.
If \code{data} is not provided, variables are evaluated from the calling environment.}

\item{freq}{Logical. If TRUE (default), displays frequencies. If FALSE, displays percentages.}

\item{col}{Color for the bars.}

\item{lwd}{Line width for the frequency bars. Default is 9.}

\item{width}{Numeric. Width of the frequency bars. If NULL (default), width is automatically calculated based on the spacing between values.}

\item{value.labels}{Logical. If TRUE, displays frequencies on top of each line.}

\item{add}{Logical. If TRUE, adds to an existing plot instead of creating a new one.}

\item{show.legend}{Logical. If TRUE (default), displays a legend when \code{group} is specified. If FALSE, no legend is shown.}

\item{legend.title}{Character string. Title for the legend when \code{group} is specified. If NULL (default), no title is shown.}

\item{col.text}{Color for the value labels. If not specified, uses \code{col} for non-grouped plots or group colors for grouped plots.}

\item{...}{Pass on any argument accepted by \code{plot()} e.g., \code{xlab='x-axis'} , \code{main='Distribution of X'}}
}
\value{
Invisibly returns a data frame with values and their frequencies.
}
\description{
Creates a frequency plot showing the frequency of every observed value,
displaying the full range from minimum to maximum value.
}
\details{
This function creates a frequency plot where each observed value is shown
with its frequency. Unlike a standard histogram, there is no binning, unlike
a barplot, non-observed values of the variable are shown with 0 frequency 
instead of skipped.
}
\examples{
# Simple example
x <- c(1, 1, 2, 2, 2, 5, 5)
plot_freq(x)

# Pass on some common \code{plot()} arguments
plot_freq(x, col = "steelblue", xlab = "Value", ylab = "Frequency",ylim=c(0,7))

# Add to an existing plot
plot_freq(x, col = "dodgerblue")
plot_freq(x + 1, col = "red", add = TRUE)

# Using a data frame
df <- data.frame(value = c(1, 1, 2, 2, 2, 5, 5), group = c("A", "A", "A", "B", "B", "A", "B"))
plot_freq(value ~ 1, data = df)  # single variable
plot_freq(value ~ group, data = df)  # with grouping

}
