#' Total Trihalomethanes in Tapwater
#' 
#' Trihalomethanes are formed as a by-product predominantly when chlorine is used to disinfect water
#' for drinking. They result from the reaction of chlorine or bromine with
#' organic matter present in the water being treated.
#' THMs  have been associated through epidemiological studies
#' with some adverse health effects and many are considered carcinogenic.
#' In the United States, the EPA limits 
#' the total concentration of the four chief constituents (chloroform, bromoform, bromodichloromethane, and dibromochloromethane), referred to as
#' total trihalomethanes (TTHM), to 80 parts per billion in treated water.
#'
#'
#' @format A dataframe with 28 rows and 6 variables:
#' \describe{
#'   \item{date}{Date of collection}
#'   \item{tthm}{average total trihalomethanes in ppb }
#'   \item{samples}{number of samples}
#'   \item{nondetects}{number of samples where tthm not detected (0)}
#'   \item{min}{min tthm in ppb in samples}
#'   \item{max}{max tthm in ppb in samples}
#' }
#' @source National Drinking Water Database for Durham, NC. \url{http://www.ewg.org/tap-water/whatsinyourwater/NC/CityofDurham/0332010/Total-trihalomethanes-TTHMs/2950/}
"tapwater"