# one-sample-test without missing data:  type=bayes, conf.level=0.95, effsize.type=g

    Code
      names(res)
    Output
       [1] "term"               "effectsize"         "estimate"          
       [4] "conf.level"         "conf.low"           "conf.high"         
       [7] "pd"                 "prior.distribution" "prior.location"    
      [10] "prior.scale"        "bf10"               "method"            
      [13] "conf.method"        "log_e_bf10"         "n.obs"             
      [16] "expression"        

---

    Code
      res$bf10[[1L]]
    Output
      [1] 1.199152e+15

# one-sample-test without missing data:  type=bayes, conf.level=0.9, effsize.type=d

    Code
      names(res)
    Output
       [1] "term"               "effectsize"         "estimate"          
       [4] "conf.level"         "conf.low"           "conf.high"         
       [7] "pd"                 "prior.distribution" "prior.location"    
      [10] "prior.scale"        "bf10"               "method"            
      [13] "conf.method"        "log_e_bf10"         "n.obs"             
      [16] "expression"        

---

    Code
      res$bf10[[1L]]
    Output
      [1] 1.199152e+15

# one-sample-test without missing data:  type=parametric, conf.level=0.95, effsize.type=g

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 14
           mu statistic df.error  p.value method            alternative effectsize
        <dbl>     <dbl>    <dbl>    <dbl> <chr>             <chr>       <chr>     
      1     5      11.1       82 4.70e-18 One Sample t-test two.sided   Hedges' g 
        estimate conf.level conf.low conf.high conf.method conf.distribution n.obs
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <chr>             <int>
      1     1.21       0.95    0.925      1.49 ncp         t                    83

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("t")["Student"] * "(" * 82 * ")" == "11.124", italic(p) == 
          "4.695e-18", widehat(italic("g"))["Hedges"] == "1.210", CI["95%"] ~ 
          "[" * "0.925", "1.490" * "]", italic("n")["obs"] == "83")
      

# one-sample-test without missing data:  type=parametric, conf.level=0.9, effsize.type=d

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 14
           mu statistic df.error  p.value method            alternative effectsize
        <dbl>     <dbl>    <dbl>    <dbl> <chr>             <chr>       <chr>     
      1     5      11.1       82 4.70e-18 One Sample t-test two.sided   Cohen's d 
        estimate conf.level conf.low conf.high conf.method conf.distribution n.obs
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <chr>             <int>
      1     1.22        0.9    0.979      1.46 ncp         t                    83

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("t")["Student"] * "(" * 82 * ")" == "11.124", italic(p) == 
          "4.695e-18", widehat(italic("d"))["Cohen"] == "1.221", CI["90%"] ~ 
          "[" * "0.979", "1.457" * "]", italic("n")["obs"] == "83")
      

# one-sample-test without missing data:  type=nonparametric, conf.level=0.95, effsize.type=g

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 11
        statistic  p.value method                    alternative effectsize       
            <dbl>    <dbl> <chr>                     <chr>       <chr>            
      1     3338. 4.43e-13 Wilcoxon signed rank test two.sided   r (rank biserial)
        estimate conf.level conf.low conf.high conf.method n.obs
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <int>
      1    0.915       0.95    0.865     0.948 normal         83

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("V")["Wilcoxon"] == "3338.500", italic(p) == "4.428e-13", 
          widehat(italic("r"))["biserial"]^"rank" == "0.915", CI["95%"] ~ 
              "[" * "0.865", "0.948" * "]", italic("n")["obs"] == "83")
      

# one-sample-test without missing data:  type=nonparametric, conf.level=0.9, effsize.type=d

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 11
        statistic  p.value method                    alternative effectsize       
            <dbl>    <dbl> <chr>                     <chr>       <chr>            
      1     3338. 4.43e-13 Wilcoxon signed rank test two.sided   r (rank biserial)
        estimate conf.level conf.low conf.high conf.method n.obs
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <int>
      1    0.915        0.9    0.874     0.943 normal         83

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("V")["Wilcoxon"] == "3338.500", italic(p) == "4.428e-13", 
          widehat(italic("r"))["biserial"]^"rank" == "0.915", CI["90%"] ~ 
              "[" * "0.874", "0.943" * "]", italic("n")["obs"] == "83")
      

# one-sample-test without missing data:  type=robust, conf.level=0.95, effsize.type=g

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 9
        statistic   p.value n.obs method                                 effectsize  
            <dbl>     <dbl> <int> <chr>                                  <chr>       
      1      9.70 2.23e-308    83 Bootstrap-t method for one-sample test Trimmed mean
        estimate conf.level conf.low conf.high
           <dbl>      <dbl>    <dbl>     <dbl>
      1     10.5       0.95     9.33      11.6

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("t")["bootstrapped"] == "9.702", italic(p) == "2.225e-308", 
          widehat(mu)["trimmed"] == "10.482", CI["95%"] ~ "[" * "9.329", 
          "11.636" * "]", italic("n")["obs"] == "83")
      

# one-sample-test without missing data:  type=robust, conf.level=0.9, effsize.type=d

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 9
        statistic   p.value n.obs method                                 effectsize  
            <dbl>     <dbl> <int> <chr>                                  <chr>       
      1      9.70 2.23e-308    83 Bootstrap-t method for one-sample test Trimmed mean
        estimate conf.level conf.low conf.high
           <dbl>      <dbl>    <dbl>     <dbl>
      1     10.5        0.9     9.51      11.5

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("t")["bootstrapped"] == "9.702", italic(p) == "2.225e-308", 
          widehat(mu)["trimmed"] == "10.482", CI["90%"] ~ "[" * "9.506", 
          "11.458" * "]", italic("n")["obs"] == "83")
      

# one-sample-test with missing data:  type=bayes, conf.level=0.95, effsize.type=g

    Code
      names(res)
    Output
       [1] "term"               "effectsize"         "estimate"          
       [4] "conf.level"         "conf.low"           "conf.high"         
       [7] "pd"                 "prior.distribution" "prior.location"    
      [10] "prior.scale"        "bf10"               "method"            
      [13] "conf.method"        "log_e_bf10"         "n.obs"             
      [16] "expression"        

---

    Code
      res$bf10[[1L]]
    Output
      [1] 0.1500561

# one-sample-test with missing data:  type=bayes, conf.level=0.9, effsize.type=d

    Code
      names(res)
    Output
       [1] "term"               "effectsize"         "estimate"          
       [4] "conf.level"         "conf.low"           "conf.high"         
       [7] "pd"                 "prior.distribution" "prior.location"    
      [10] "prior.scale"        "bf10"               "method"            
      [13] "conf.method"        "log_e_bf10"         "n.obs"             
      [16] "expression"        

---

    Code
      res$bf10[[1L]]
    Output
      [1] 0.1500561

# one-sample-test with missing data:  type=parametric, conf.level=0.95, effsize.type=g

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 14
           mu statistic df.error p.value method            alternative effectsize
        <dbl>     <dbl>    <dbl>   <dbl> <chr>             <chr>       <chr>     
      1  0.25     0.242       55   0.810 One Sample t-test two.sided   Hedges' g 
        estimate conf.level conf.low conf.high conf.method conf.distribution n.obs
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <chr>             <int>
      1   0.0319       0.95   -0.227     0.290 ncp         t                    56

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("t")["Student"] * "(" * 55 * ")" == "0.242", italic(p) == 
          "0.810", widehat(italic("g"))["Hedges"] == "0.032", CI["95%"] ~ 
          "[" * "-0.227", "0.290" * "]", italic("n")["obs"] == "56")
      

# one-sample-test with missing data:  type=parametric, conf.level=0.9, effsize.type=d

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 14
           mu statistic df.error p.value method            alternative effectsize
        <dbl>     <dbl>    <dbl>   <dbl> <chr>             <chr>       <chr>     
      1  0.25     0.242       55   0.810 One Sample t-test two.sided   Cohen's d 
        estimate conf.level conf.low conf.high conf.method conf.distribution n.obs
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <chr>             <int>
      1   0.0323        0.9   -0.188     0.252 ncp         t                    56

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("t")["Student"] * "(" * 55 * ")" == "0.242", italic(p) == 
          "0.810", widehat(italic("d"))["Cohen"] == "0.032", CI["90%"] ~ 
          "[" * "-0.188", "0.252" * "]", italic("n")["obs"] == "56")
      

# one-sample-test with missing data:  type=nonparametric, conf.level=0.95, effsize.type=g

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 11
        statistic   p.value method                    alternative effectsize       
            <dbl>     <dbl> <chr>                     <chr>       <chr>            
      1       262 0.0000125 Wilcoxon signed rank test two.sided   r (rank biserial)
        estimate conf.level conf.low conf.high conf.method n.obs
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <int>
      1   -0.672       0.95   -0.806    -0.472 normal         56

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("V")["Wilcoxon"] == "262.000", italic(p) == "1.253e-05", 
          widehat(italic("r"))["biserial"]^"rank" == "-0.672", CI["95%"] ~ 
              "[" * "-0.806", "-0.472" * "]", italic("n")["obs"] == 
              "56")
      

# one-sample-test with missing data:  type=nonparametric, conf.level=0.9, effsize.type=d

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 11
        statistic   p.value method                    alternative effectsize       
            <dbl>     <dbl> <chr>                     <chr>       <chr>            
      1       262 0.0000125 Wilcoxon signed rank test two.sided   r (rank biserial)
        estimate conf.level conf.low conf.high conf.method n.obs
           <dbl>      <dbl>    <dbl>     <dbl> <chr>       <int>
      1   -0.672        0.9   -0.788    -0.509 normal         56

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("V")["Wilcoxon"] == "262.000", italic(p) == "1.253e-05", 
          widehat(italic("r"))["biserial"]^"rank" == "-0.672", CI["90%"] ~ 
              "[" * "-0.788", "-0.509" * "]", italic("n")["obs"] == 
              "56")
      

# one-sample-test with missing data:  type=robust, conf.level=0.95, effsize.type=g

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 9
        statistic p.value n.obs method                                 effectsize  
            <dbl>   <dbl> <int> <chr>                                  <chr>       
      1     -13.2   0.005    56 Bootstrap-t method for one-sample test Trimmed mean
        estimate conf.level conf.low conf.high
           <dbl>      <dbl>    <dbl>     <dbl>
      1   0.0390       0.95  -0.0132    0.0911

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("t")["bootstrapped"] == "-13.164", italic(p) == "0.005", 
          widehat(mu)["trimmed"] == "0.039", CI["95%"] ~ "[" * "-0.013", 
          "0.091" * "]", italic("n")["obs"] == "56")
      

# one-sample-test with missing data:  type=robust, conf.level=0.9, effsize.type=d

    Code
      select(res, -expression)
    Output
      # A tibble: 1 x 9
        statistic p.value n.obs method                                 effectsize  
            <dbl>   <dbl> <int> <chr>                                  <chr>       
      1     -13.2   0.005    56 Bootstrap-t method for one-sample test Trimmed mean
        estimate conf.level conf.low conf.high
           <dbl>      <dbl>    <dbl>     <dbl>
      1   0.0390        0.9  0.00419    0.0737

---

    Code
      res[["expression"]]
    Output
      [[1]]
      list(italic("t")["bootstrapped"] == "-13.164", italic(p) == "0.005", 
          widehat(mu)["trimmed"] == "0.039", CI["90%"] ~ "[" * "0.004", 
          "0.074" * "]", italic("n")["obs"] == "56")
      

