% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise-comparisons.R
\name{pairwise_comparisons}
\alias{pairwise_comparisons}
\title{Multiple pairwise comparison for one-way design}
\usage{
pairwise_comparisons(
  data,
  x,
  y,
  subject.id = NULL,
  type = "parametric",
  paired = FALSE,
  var.equal = FALSE,
  tr = 0.2,
  bf.prior = 0.707,
  p.adjust.method = "holm",
  digits = 2L,
  ...
)
}
\arguments{
\item{data}{A data frame (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted. Additionally, grouped data frames from \code{{dplyr}} should be
ungrouped before they are entered as \code{data}.}

\item{x}{The grouping (or independent) variable from \code{data}. In case of a
repeated measures or within-subjects design, if \code{subject.id} argument is
not available or not explicitly specified, the function assumes that the
data has already been sorted by such an id by the user and creates an
internal identifier. So if your data is \strong{not} sorted, the results \emph{can}
be inaccurate when there are more than two levels in \code{x} and there are
\code{NA}s present. The data is expected to be sorted by user in
subject-1, subject-2, ..., pattern.}

\item{y}{The response (or outcome or dependent) variable from \code{data}.}

\item{subject.id}{Relevant in case of a repeated measures or within-subjects
design (\code{paired = TRUE}, i.e.), it specifies the subject or repeated
measures identifier. \strong{Important}: Note that if this argument is \code{NULL}
(which is the default), the function assumes that the data has already been
sorted by such an id by the user and creates an internal identifier. So if
your data is \strong{not} sorted and you leave this argument unspecified, the
results \emph{can} be inaccurate when there are more than two levels in \code{x} and
there are \code{NA}s present.}

\item{type}{A character specifying the type of statistical approach:
\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

You can specify just the initial letter.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors and posterior estimates. In
addition to numeric arguments, several named values are also recognized:
\code{"medium"}, \code{"wide"}, and \code{"ultrawide"}, corresponding to \emph{r} scale values
of \code{1/2}, \code{sqrt(2)/2}, and \code{1}, respectively. In case of an ANOVA, this
value corresponds to scale for fixed effects.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{...}{Additional arguments passed to other methods.}
}
\value{
The returned tibble data frame can contain some or all of the following columns (the exact columns will depend on the statistical test):
\itemize{
\item \code{statistic}: the numeric value of a statistic
\item \code{df}: the numeric value of a parameter being modeled (often degrees
of freedom for the test)
\item \code{df.error} and \code{df}: relevant only if the statistic in question has
two degrees of freedom (e.g. anova)
\item \code{p.value}: the two-sided \emph{p}-value associated with the observed statistic
\item \code{method}: the name of the inferential statistical test
\item \code{estimate}: estimated value of the effect size
\item \code{conf.low}: lower bound for the effect size estimate
\item \code{conf.high}: upper bound for the effect size estimate
\item \code{conf.level}: width of the confidence interval
\item \code{conf.method}: method used to compute confidence interval
\item \code{conf.distribution}: statistical distribution for the effect
\item \code{effectsize}: the name of the effect size
\item \code{n.obs}: number of observations
\item \code{expression}: pre-formatted expression containing statistical details
}

For examples, see \href{https://indrajeetpatil.github.io/statsExpressions/articles/web_only/dataframe_outputs.html}{data frame output vignette}.
}
\description{
Calculate parametric, non-parametric, robust, and Bayes Factor pairwise
comparisons between group levels with corrections for multiple testing.
}
\section{Pairwise comparison tests}{


The table below provides summary about:
\itemize{
\item statistical test carried out for inferential statistics
\item type of effect size estimate and a measure of uncertainty for this estimate
\item functions used internally to compute these details
}
\subsection{between-subjects}{

\strong{Hypothesis testing}\tabular{lllll}{
   Type \tab Equal variance? \tab Test \tab \emph{p}-value adjustment? \tab Function used \cr
   Parametric \tab No \tab Games-Howell test \tab Yes \tab \code{PMCMRplus::gamesHowellTest()} \cr
   Parametric \tab Yes \tab Student's \emph{t}-test \tab Yes \tab \code{stats::pairwise.t.test()} \cr
   Non-parametric \tab No \tab Dunn test \tab Yes \tab \code{PMCMRplus::kwAllPairsDunnTest()} \cr
   Robust \tab No \tab Yuen's trimmed means test \tab Yes \tab \code{WRS2::lincon()} \cr
   Bayesian \tab \code{NA} \tab Student's \emph{t}-test \tab \code{NA} \tab \code{BayesFactor::ttestBF()} \cr
}


\strong{Effect size estimation}

Not supported.
}

\subsection{within-subjects}{

\strong{Hypothesis testing}\tabular{llll}{
   Type \tab Test \tab \emph{p}-value adjustment? \tab Function used \cr
   Parametric \tab Student's \emph{t}-test \tab Yes \tab \code{stats::pairwise.t.test()} \cr
   Non-parametric \tab Durbin-Conover test \tab Yes \tab \code{PMCMRplus::durbinAllPairsTest()} \cr
   Robust \tab Yuen's trimmed means test \tab Yes \tab \code{WRS2::rmmcp()} \cr
   Bayesian \tab Student's \emph{t}-test \tab \code{NA} \tab \code{BayesFactor::ttestBF()} \cr
}


\strong{Effect size estimation}

Not supported.
}
}

\section{Citation}{
Patil, I., (2021). statsExpressions: R Package for Tidy Dataframes and Expressions with Statistical Details. Journal of Open Source Software, 6(61), 3236, https://doi.org/10.21105/joss.03236
}

\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# for reproducibility
set.seed(123)
library(statsExpressions)

#------------------- between-subjects design ----------------------------

# parametric
# if `var.equal = TRUE`, then Student's t-test will be run
pairwise_comparisons(
  data            = mtcars,
  x               = cyl,
  y               = wt,
  type            = "parametric",
  var.equal       = TRUE,
  paired          = FALSE,
  p.adjust.method = "none"
)

# if `var.equal = FALSE`, then Games-Howell test will be run
pairwise_comparisons(
  data            = mtcars,
  x               = cyl,
  y               = wt,
  type            = "parametric",
  var.equal       = FALSE,
  paired          = FALSE,
  p.adjust.method = "bonferroni"
)

# non-parametric (Dunn test)
pairwise_comparisons(
  data            = mtcars,
  x               = cyl,
  y               = wt,
  type            = "nonparametric",
  paired          = FALSE,
  p.adjust.method = "none"
)

# robust (Yuen's trimmed means *t*-test)
pairwise_comparisons(
  data            = mtcars,
  x               = cyl,
  y               = wt,
  type            = "robust",
  paired          = FALSE,
  p.adjust.method = "fdr"
)

# Bayes Factor (Student's *t*-test)
pairwise_comparisons(
  data   = mtcars,
  x      = cyl,
  y      = wt,
  type   = "bayes",
  paired = FALSE
)

#------------------- within-subjects design ----------------------------

# parametric (Student's *t*-test)
pairwise_comparisons(
  data            = bugs_long,
  x               = condition,
  y               = desire,
  subject.id      = subject,
  type            = "parametric",
  paired          = TRUE,
  p.adjust.method = "BH"
)

# non-parametric (Durbin-Conover test)
pairwise_comparisons(
  data            = bugs_long,
  x               = condition,
  y               = desire,
  subject.id      = subject,
  type            = "nonparametric",
  paired          = TRUE,
  p.adjust.method = "BY"
)

# robust (Yuen's trimmed means t-test)
pairwise_comparisons(
  data            = bugs_long,
  x               = condition,
  y               = desire,
  subject.id      = subject,
  type            = "robust",
  paired          = TRUE,
  p.adjust.method = "hommel"
)

# Bayes Factor (Student's *t*-test)
pairwise_comparisons(
  data       = bugs_long,
  x          = condition,
  y          = desire,
  subject.id = subject,
  type       = "bayes",
  paired     = TRUE
)
\dontshow{\}) # examplesIf}
}
\references{
For more, see:
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/pairwise.html}
}
