% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_t_test_expressions.R
\name{expr_t_parametric}
\alias{expr_t_parametric}
\title{Making expression containing \emph{t}-test results}
\usage{
expr_t_parametric(
  data,
  x,
  y,
  paired = FALSE,
  effsize.type = "g",
  effsize.noncentral = TRUE,
  conf.level = 0.95,
  var.equal = FALSE,
  k = 2,
  stat.title = NULL,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}). The default is \code{"g"}.}

\item{effsize.noncentral}{Logical indicating whether to use non-central
\emph{t}-distributions for computing the confidence interval for Cohen's \emph{d}
or Hedge's \emph{g} (Default: \code{TRUE}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Expression containing details from results of a two-sample test and
effect size plus confidence intervals.
}
\description{
Making expression containing \emph{t}-test results
}
\details{
Cohen's \emph{d} is calculated in the traditional fashion as the
difference between means or mean minus \emph{mu} divided by the estimated
standardized deviation.  By default Hedge's correction is applied
(\emph{N}-3)/(\emph{N}-2.25) to produce \emph{g}. For independent samples \emph{t}-test, there
are two possibilities implemented. If the \emph{t}-test did not make a
homogeneity of variance assumption, (the Welch test), the variance term
will mirror the Welch test, otherwise a pooled and weighted estimate is
used. If a paired samples \emph{t}-test was requested, then effect size desired
is based on the standard deviation of the differences.

The computation of the confidence intervals defaults to a use of
non-central Student-\emph{t} distributions (\code{effsize.noncentral = TRUE});
otherwise a central distribution is used.

When computing confidence intervals the variance of the effect size \emph{d} or
\emph{g} is computed using the conversion formula reported in Cooper et al.
(2009)
\itemize{
\item \code{((n1+n2)/(n1*n2) + .5*d^2/df) * ((n1+n2)/df)} (independent samples)
\item \code{sqrt(((1 / n) + (d^2 / n)) * 2 * (1 - r))}  (paired case)
}
}
\examples{
# for reproducibility
set.seed(123)
\donttest{
# creating a smaller dataset
msleep_short <- dplyr::filter(
  .data = ggplot2::msleep,
  vore \%in\% c("carni", "herbi")
)

# with defaults
statsExpressions::expr_t_parametric(
  data = msleep_short,
  x = vore,
  y = sleep_rem
)

# changing defaults
statsExpressions::expr_t_parametric(
  data = msleep_short,
  x = vore,
  y = sleep_rem,
  var.equal = TRUE,
  k = 2,
  effsize.type = "d"
)
}
}
\references{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\author{
\href{https://github.com/IndrajeetPatil}{Indrajeet Patil}, Chuck Powell
}
