% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_anova_expressions.R
\name{expr_anova_nonparametric}
\alias{expr_anova_nonparametric}
\title{Making text subtitle for nonparametric ANOVA.}
\usage{
expr_anova_nonparametric(
  data,
  x,
  y,
  paired = FALSE,
  conf.type = "perc",
  conf.level = 0.95,
  k = 2,
  nboot = 100,
  stat.title = NULL,
  messages = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
\description{
Making text subtitle for nonparametric ANOVA.
}
\details{
For paired designs, the effect size is Kendall's coefficient of
concordance (\emph{W}), while for between-subjects designs, the effect size is
epsilon-squared (for more, see \code{?rcompanion::epsilonSquared} and
\code{?rcompanion::kendallW}).
}
\examples{
\donttest{
# setup
set.seed(123)
library(statsExpressions)

# -------------- within-subjects design --------------------------------

# creating the subtitle
statsExpressions::expr_anova_nonparametric(
  data = bugs_long,
  x = condition,
  y = desire,
  paired = TRUE,
  conf.level = 0.99,
  k = 2
)

# -------------- between-subjects design --------------------------------

statsExpressions::expr_anova_nonparametric(
  data = ggplot2::msleep,
  x = vore,
  y = sleep_rem,
  paired = FALSE,
  conf.level = 0.99,
  conf.type = "perc"
)
}
}
\author{
\href{https://github.com/IndrajeetPatil}{Indrajeet Patil}
}
